/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.custom.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class BaseScreen
extends Screen {
    private static final ResourceLocation BLANK_BACKGROUND = new ResourceLocation("custommachinery", "textures/gui/background.png");
    private final List<Widget> customWidgets = new ArrayList<Widget>();
    private final List<Pair<DragType, Rectangle>> draggingAreas = new ArrayList<Pair<DragType, Rectangle>>();
    public final int xSize;
    public final int ySize;
    private int xPos;
    private int yPos;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double widthOffset = 0.0;
    private double heightOffset = 0.0;
    private DragType currentDragType = DragType.NONE;
    @Nullable
    private PopupScreen popup = null;

    public BaseScreen(Component component, int xSize, int ySize) {
        super(component);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public int getX() {
        return this.xPos + (int)this.xOffset;
    }

    public int getY() {
        return this.yPos + (int)this.yOffset;
    }

    public int getWidth() {
        return this.xSize + (int)this.widthOffset;
    }

    public int getHeight() {
        return this.ySize + (int)this.heightOffset;
    }

    public <T extends Widget> T addCustomWidget(T widget) {
        this.customWidgets.add(widget);
        return widget;
    }

    protected <T extends GuiEventListener & NarratableEntry> T m_7787_(T listener) {
        throw new IllegalStateException("Forbidden method");
    }

    protected <T extends net.minecraft.client.gui.components.Widget> T m_169394_(T widget) {
        throw new IllegalStateException("Forbidden method");
    }

    protected <T extends GuiEventListener & net.minecraft.client.gui.components.Widget> T m_142416_(T widget) {
        throw new IllegalStateException("Forbidden method");
    }

    public void openPopup(PopupScreen popup) {
        this.popup = popup;
        this.popup.setParent(this);
        this.popup.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
    }

    public void closePopup() {
        this.popup = null;
    }

    public void addDraggingArea(DragType type, Rectangle rectangle) {
        this.draggingAreas.add((Pair<DragType, Rectangle>)Pair.of((Object)((Object)type), (Object)rectangle));
    }

    public DragType getDragType(double mouseX, double mouseY) {
        for (Pair<DragType, Rectangle> pair : this.draggingAreas) {
            if (!((Rectangle)pair.getSecond()).isIn(mouseX, mouseY)) continue;
            return (DragType)((Object)pair.getFirst());
        }
        return DragType.NONE;
    }

    public void baseMoveDraggingArea() {
        this.addDraggingArea(DragType.MOVE, new Rectangle(() -> this.getX() + 2, () -> this.getX() + this.getWidth() - 2, () -> this.getY() + 2, () -> this.getY() + 10));
    }

    public void baseSizeDraggingArea(int margin) {
        this.addDraggingArea(DragType.TOP, new Rectangle(() -> this.getX() + margin, () -> this.getX() + this.getWidth() - margin, () -> this.getY() - margin, () -> this.getY() + margin));
        this.addDraggingArea(DragType.TOP_LEFT, new Rectangle(() -> this.getX() - margin, () -> this.getX() + margin, () -> this.getY() - margin, () -> this.getY() + margin));
        this.addDraggingArea(DragType.TOP_RIGHT, new Rectangle(() -> this.getX() + this.getWidth() - margin, () -> this.getX() + this.getWidth() + margin, () -> this.getY() - margin, () -> this.getY() + margin));
        this.addDraggingArea(DragType.LEFT, new Rectangle(() -> this.getX() - margin, () -> this.getX() + margin, () -> this.getY() + margin, () -> this.getY() + this.getHeight() - margin));
        this.addDraggingArea(DragType.RIGHT, new Rectangle(() -> this.getX() + this.getWidth() - margin, () -> this.getX() + this.getWidth() + margin, () -> this.getY() + margin, () -> this.getY() + this.getHeight() - margin));
        this.addDraggingArea(DragType.BOTTOM, new Rectangle(() -> this.getX() + margin, () -> this.getX() + this.getWidth() - margin, () -> this.getY() + this.getHeight() - margin, () -> this.getY() + this.getHeight() + margin));
        this.addDraggingArea(DragType.BOTTOM_LEFT, new Rectangle(() -> this.getX() - margin, () -> this.getX() + margin, () -> this.getY() + this.getHeight() - margin, () -> this.getY() + this.getHeight() + margin));
        this.addDraggingArea(DragType.BOTTOM_RIGHT, new Rectangle(() -> this.getX() + this.getWidth() - margin, () -> this.getX() + this.getWidth() + margin, () -> this.getY() + this.getHeight() - margin, () -> this.getY() + this.getHeight() + margin));
    }

    protected void m_7856_() {
        this.customWidgets.clear();
        this.draggingAreas.clear();
        this.xPos = (this.f_96543_ - this.xSize) / 2;
        this.yPos = (this.f_96544_ - this.ySize) / 2;
        if (this.popup != null) {
            this.popup.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.customWidgets.forEach(widget -> widget.render(poseStack, mouseX, mouseY, partialTicks));
        if (this.popup != null) {
            this.popup.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            return;
        }
        this.customWidgets.stream().filter(widget -> widget.m_5953_(mouseX, mouseY)).forEach(widget -> this.m_169388_(poseStack, widget.getTooltips(), Optional.empty(), mouseX, mouseY));
    }

    public void m_7333_(PoseStack pose) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.popup != null) {
            return this.popup.m_6375_(mouseX, mouseY, button);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.m_5953_(mouseX, mouseY) || !widget.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        this.currentDragType = this.getDragType(mouseX, mouseY);
        if (this.currentDragType != DragType.NONE) {
            this.m_7897_(true);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.m_7897_(false);
        this.currentDragType = DragType.NONE;
        if (this.popup != null) {
            return this.popup.m_6348_(mouseX, mouseY, button);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.m_5953_(mouseX, mouseY) || !widget.m_6348_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.popup != null) {
            return this.popup.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        if (this.m_7282_() && button == 0 && this.currentDragType != DragType.NONE) {
            switch (this.currentDragType) {
                case MOVE: {
                    this.xOffset += dragX;
                    this.yOffset += dragY;
                    break;
                }
                case TOP: {
                    this.yOffset = Math.min(0.0, this.yOffset + dragY);
                    this.heightOffset = Math.max(0.0, this.heightOffset - dragY);
                    break;
                }
                case BOTTOM: {
                    this.heightOffset = Math.max(0.0, this.heightOffset + dragY);
                    break;
                }
                case LEFT: {
                    this.widthOffset = Math.max(0.0, this.widthOffset - dragX);
                    if (!(this.widthOffset > 0.0)) break;
                    this.xOffset = Math.min(0.0, this.xOffset + dragX);
                    break;
                }
                case RIGHT: {
                    this.widthOffset = Math.max(0.0, this.widthOffset + dragX);
                    break;
                }
                case TOP_LEFT: 
                case TOP_RIGHT: 
                case BOTTOM_LEFT: 
                case BOTTOM_RIGHT: {
                    this.widthOffset += dragX;
                    this.heightOffset += dragY;
                }
            }
            return true;
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.m_5953_(mouseX, mouseY) || !widget.m_7979_(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.popup != null) {
            return this.popup.m_6050_(mouseX, mouseY, delta);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.m_5953_(mouseX, mouseY) || !widget.m_6050_(mouseX, mouseY, delta)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.popup != null) {
            return this.popup.m_7933_(keyCode, scanCode, modifiers);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.popup != null) {
            return this.popup.m_7920_(keyCode, scanCode, modifiers);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.m_7920_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public static void baseBackground(PoseStack pose, int x, int y, int width, int height) {
        GuiComponent.m_168740_((PoseStack)pose, (int)x, (int)y, (int)width, (int)height, (int)-1072689136, (int)-804253680, (int)0);
    }

    public static void blankBackground(PoseStack pose, int x, int y, int width, int height) {
        BaseScreen.bindTexture(BLANK_BACKGROUND);
        BaseScreen.m_93133_((PoseStack)pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)4, (int)4, (int)8, (int)8);
        BaseScreen.m_93160_((PoseStack)pose, (int)(x + 4), (int)y, (int)(width - 8), (int)4, (float)4.0f, (float)0.0f, (int)1, (int)4, (int)8, (int)8);
        BaseScreen.m_93133_((PoseStack)pose, (int)(x + width - 4), (int)y, (float)4.0f, (float)0.0f, (int)4, (int)3, (int)8, (int)8);
        BaseScreen.m_93160_((PoseStack)pose, (int)x, (int)(y + 4), (int)4, (int)(height - 7), (float)0.0f, (float)4.0f, (int)4, (int)1, (int)8, (int)8);
        BaseScreen.m_93160_((PoseStack)pose, (int)(x + 4), (int)(y + 4), (int)(width - 7), (int)(height - 7), (float)4.0f, (float)3.0f, (int)1, (int)1, (int)8, (int)8);
        BaseScreen.m_93160_((PoseStack)pose, (int)(x + width - 4), (int)(y + 3), (int)4, (int)(height - 7), (float)4.0f, (float)3.0f, (int)4, (int)1, (int)8, (int)8);
        BaseScreen.m_93133_((PoseStack)pose, (int)x, (int)(y + height - 3), (float)0.0f, (float)5.0f, (int)4, (int)3, (int)8, (int)8);
        BaseScreen.m_93160_((PoseStack)pose, (int)(x + 4), (int)(y + height - 4), (int)(width - 8), (int)4, (float)3.0f, (float)4.0f, (int)1, (int)4, (int)8, (int)8);
        BaseScreen.m_93160_((PoseStack)pose, (int)(x + width - 4), (int)(y + height - 4), (int)4, (int)4, (float)4.0f, (float)4.0f, (int)4, (int)4, (int)8, (int)8);
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum DragType {
        MOVE,
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        NONE;

    }

    public static class Rectangle {
        private final Supplier<Integer> left;
        private final Supplier<Integer> right;
        private final Supplier<Integer> top;
        private final Supplier<Integer> bottom;

        public Rectangle(Supplier<Integer> left, Supplier<Integer> right, Supplier<Integer> top, Supplier<Integer> bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public boolean isIn(double x, double y) {
            return x >= (double)this.left.get().intValue() && x <= (double)this.right.get().intValue() && y >= (double)this.top.get().intValue() && y <= (double)this.bottom.get().intValue();
        }

        public void render(PoseStack pose, int color) {
            GuiComponent.m_93172_((PoseStack)pose, (int)this.left.get(), (int)this.top.get(), (int)this.right.get(), (int)this.bottom.get(), (int)color);
        }
    }
}

