/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.client.render.ColoredBufferSource;
import fr.frinn.custommachinery.common.guielement.SizeGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.network.CGuiElementClickPacket;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.common.util.slot.FilterSlotItemComponent;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import fr.frinn.custommachinery.impl.guielement.GuiElementWidgetSupplierRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CustomMachineScreen
extends AbstractContainerScreen<CustomMachineContainer>
implements IMachineScreen {
    private final CustomMachineTile tile;
    private final CustomMachine machine;
    private final List<AbstractGuiElementWidget<?>> elementWidgets = new ArrayList();

    public CustomMachineScreen(CustomMachineContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tile = container.getTile();
        this.machine = container.getTile().getMachine();
        this.f_97726_ = 256;
        this.f_97727_ = 192;
        this.tile.getGuiElements().stream().filter(element -> element instanceof SizeGuiElement).map(element -> (SizeGuiElement)element).findFirst().ifPresent(size -> {
            this.f_97726_ = size.getWidth();
            this.f_97727_ = size.getHeight();
        });
    }

    protected void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.elementWidgets.clear();
        this.tile.getGuiElements().stream().filter(element -> GuiElementWidgetSupplierRegistry.hasWidgetSupplier(element.getType())).sorted(Comparators.GUI_ELEMENTS_COMPARATOR.reversed()).forEach(element -> this.addElementWidget(GuiElementWidgetSupplierRegistry.getWidgetSupplier(element.getType()).get((IGuiElement)element, this)));
    }

    private void addElementWidget(AbstractGuiElementWidget<?> widget) {
        this.elementWidgets.add(widget);
        this.m_142416_((GuiEventListener)widget);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.elementWidgets.forEach(widget -> {
            if (widget.m_198029_()) {
                widget.m_7428_(poseStack, mouseX, mouseY);
            }
        });
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_97799_(PoseStack pose, Slot slot) {
        if (slot instanceof FilterSlotItemComponent) {
            FilterSlotItemComponent filterSlot = (FilterSlotItemComponent)slot;
            if (slot.m_6657_()) {
                this.drawGhostItem(pose, slot.m_7993_(), slot.f_40220_, slot.f_40221_, FastColor.ARGB32.m_13660_((int)128, (int)255, (int)255, (int)255));
                return;
            }
        }
        super.m_97799_(pose, slot);
    }

    @Override
    public int getX() {
        return this.f_97735_;
    }

    @Override
    public int getY() {
        return this.f_97736_;
    }

    @Override
    public int getWidth() {
        return this.f_97726_;
    }

    @Override
    public int getHeight() {
        return this.f_97727_;
    }

    @Override
    public CustomMachine getMachine() {
        return this.machine;
    }

    @Override
    public CustomMachineTile getTile() {
        return this.tile;
    }

    public CustomMachineScreen getScreen() {
        return this;
    }

    @Override
    public void drawTooltips(PoseStack pose, List<Component> tooltips, int mouseX, int mouseY) {
        super.m_96597_(pose, tooltips, mouseX, mouseY);
    }

    @Override
    public void drawGhostItem(PoseStack pose, ItemStack item, int posX, int posY, int color) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)posX, (double)posY, (double)(100.0f + itemRenderer.f_115093_));
        poseStack.m_85837_(8.0, 8.0, 0.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack2 = new PoseStack();
        ColoredBufferSource bufferSource = new ColoredBufferSource(Minecraft.m_91087_().m_91269_().m_110104_(), color);
        BakedModel model = itemRenderer.m_174264_(item, null, null, 0);
        if (!model.m_7547_()) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(item, ItemTransforms.TransformType.GUI, false, poseStack2, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, model);
        bufferSource.endBatch();
        RenderSystem.m_69482_();
        if (!model.m_7547_()) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (AbstractGuiElementWidget<?> elementWidget : this.elementWidgets) {
            if (!elementWidget.m_6375_(mouseX, mouseY, button)) continue;
            new CGuiElementClickPacket(this.tile.getGuiElements().indexOf(elementWidget.getElement()), (byte)button).sendToServer();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public Optional<AbstractGuiElementWidget<?>> getElementUnderMouse(double mouseX, double mouseY) {
        for (AbstractGuiElementWidget<?> elementWidget : this.elementWidgets) {
            if (!elementWidget.m_5953_(mouseX, mouseY) || !elementWidget.isClickable()) continue;
            return Optional.of(elementWidget);
        }
        return Optional.empty();
    }
}

