/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creator;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.popup.ConfirmPopup;
import fr.frinn.custommachinery.client.screen.widget.custom.ButtonWidget;
import fr.frinn.custommachinery.client.screen.widget.custom.ListWidget;
import fr.frinn.custommachinery.client.screen.widget.custom.MachineList;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.network.CRemoveMachinePacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MachineCreationScreen
extends BaseScreen {
    public static final MachineCreationScreen INSTANCE = new MachineCreationScreen();
    private static final Component CREATE = Component.m_237115_((String)"custommachinery.gui.creation.create");
    private static final Component SAVE = Component.m_237115_((String)"custommachinery.gui.creation.save");
    private static final Component DELETE = Component.m_237115_((String)"custommachinery.gui.creation.delete");
    private static final ResourceLocation CREATE_TEXTURE = new ResourceLocation("custommachinery", "textures/gui/creation/create_icon.png");
    private static final ResourceLocation SAVE_TEXTURE = new ResourceLocation("custommachinery", "textures/gui/creation/save_icon.png");
    private static final ResourceLocation DELETE_TEXTURE = new ResourceLocation("custommachinery", "textures/gui/creation/delete_icon.png");
    private ListWidget<CustomMachineBuilder, MachineList.MachineEntry> machineList;
    private ButtonWidget create;
    private ButtonWidget save;
    private ButtonWidget delete;
    private final List<CustomMachineBuilder> builders = new ArrayList<CustomMachineBuilder>();
    @Nullable
    private CustomMachineBuilder selected = null;

    public MachineCreationScreen() {
        super((Component)Component.m_237113_((String)"Machine Creator"), 72, 166);
        CustomMachinery.MACHINES.values().stream().map(CustomMachineBuilder::new).forEach(this.builders::add);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.baseMoveDraggingArea();
        this.baseSizeDraggingArea(3);
        this.machineList = this.addCustomWidget(new MachineList(() -> this.getX() + 4, () -> this.getY() + 4, 64, 136).selectionCallback(this::select));
        this.builders.forEach(this.machineList::add);
        if (this.selected != null) {
            this.machineList.setSelected(this.selected);
        }
        this.create = this.addCustomWidget(new ButtonWidget(() -> this.getX() + 4, () -> this.getY() + 142, 20, 20).title(CREATE, false).texture(CREATE_TEXTURE).callback(this::create).tooltip(CREATE));
        this.save = this.addCustomWidget(new ButtonWidget(() -> this.getX() + 26, () -> this.getY() + 142, 20, 20).title(SAVE, false).texture(SAVE_TEXTURE).callback(this::save).tooltip(SAVE));
        this.delete = this.addCustomWidget(new ButtonWidget(() -> this.getX() + 48, () -> this.getY() + 142, 20, 20).title(DELETE, false).texture(DELETE_TEXTURE).callback(button -> {
            if (this.selected == null) {
                return;
            }
            this.openPopup(new ConfirmPopup(190, 100, this::delete).text(new Component[]{Component.m_237113_((String)"The following machine will be deleted"), this.selected.getName(), Component.m_237113_((String)"This can't be undone!")}));
        }).tooltip(DELETE));
    }

    @Override
    public void m_7333_(PoseStack pose) {
        MachineCreationScreen.blankBackground(pose, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private void select(@Nullable CustomMachineBuilder selected) {
        this.selected = selected;
    }

    private void create(ButtonWidget button) {
    }

    private void save(ButtonWidget button) {
    }

    private void delete() {
        if (this.selected == null) {
            return;
        }
        this.builders.remove(this.selected);
        ResourceLocation id = this.selected.getLocation().getId();
        CustomMachinery.MACHINES.remove(id);
        new CRemoveMachinePacket(id).sendToServer();
        this.selected = null;
        this.m_7856_();
    }

    public void refreshMachineList() {
        this.builders.removeIf(builder -> !CustomMachinery.MACHINES.containsKey(builder.getLocation().getId()));
        CustomMachinery.MACHINES.forEach((id, machine) -> {
            if (this.builders.stream().noneMatch(builder -> builder.getLocation().getId().equals(id))) {
                this.builders.add(new CustomMachineBuilder((CustomMachine)machine));
            }
        });
        this.m_7856_();
    }
}

