/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creator_old;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.screen.creator_old.MachineCreationScreen;
import fr.frinn.custommachinery.client.screen.creator_old.MachineList;
import fr.frinn.custommachinery.client.screen.widget.TexturedButton;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.network.CAddMachinePacket;
import fr.frinn.custommachinery.common.util.FileUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MachineLoadingScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("custommachinery", "textures/gui/creation/machine_list_background.png");
    public static final MachineLoadingScreen INSTANCE = new MachineLoadingScreen();
    private int xSize = 72;
    private int ySize = 166;
    private int xPos;
    private int yPos;
    private MachineList machineList;
    private Map<CustomMachineBuilder, MachineCreationScreen> machineCreationScreens = new HashMap<CustomMachineBuilder, MachineCreationScreen>();
    private CustomMachineBuilder selectedMachine;
    private Button createButton;
    private Button saveButton;
    private Button deleteButton;

    public MachineLoadingScreen() {
        super((Component)Component.m_237119_());
        CustomMachinery.MACHINES.forEach((id, machine) -> {
            CustomMachineBuilder machineBuilder = new CustomMachineBuilder((CustomMachine)machine);
            this.machineCreationScreens.put(machineBuilder, new MachineCreationScreen(machineBuilder));
        });
    }

    protected void m_7856_() {
        this.xPos = (this.f_96543_ - 256) / 2 - this.xSize - 5;
        this.yPos = (this.f_96544_ - 166) / 2;
        this.machineList = new MachineList(this.f_96541_, this.xSize - 5, this.ySize - 28, this.xPos + 3, this.yPos + 1, 20, this);
        this.machineCreationScreens.forEach((machineBuilder, screen) -> this.machineList.addMachineEntry((CustomMachineBuilder)machineBuilder));
        this.m_6702_().add(this.machineList);
        this.machineCreationScreens.forEach((machineBuilder, screen) -> screen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_));
        this.machineList.m_6702_().forEach(entry -> {
            if (this.selectedMachine != null && this.selectedMachine == entry.getMachineBuilder()) {
                this.machineList.setSelected((MachineList.MachineEntry)((Object)entry));
            }
        });
        this.createButton = (Button)this.m_142416_((GuiEventListener)new TexturedButton(this.xPos + 4, this.yPos + 141, 20, 20, (Component)Component.m_237119_(), new ResourceLocation("custommachinery", "textures/gui/creation/create_icon.png"), button -> this.create(), (button, matrix, mouseX, mouseY) -> this.m_96602_(matrix, (Component)Component.m_237113_((String)""), mouseX, mouseY)));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new TexturedButton(this.xPos + 26, this.yPos + 141, 20, 20, (Component)Component.m_237119_(), new ResourceLocation("custommachinery", "textures/gui/creation/save_icon.png"), button -> this.save(), (button, matrix, mouseX, mouseY) -> {
            Component tooltip = this.selectedMachine == null ? null : (this.selectedMachine.getLocation().getLoader() == MachineLocation.Loader.DATAPACK ? null : null);
            this.m_96602_(matrix, tooltip, mouseX, mouseY);
        }));
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new TexturedButton(this.xPos + 48, this.yPos + 141, 20, 20, (Component)Component.m_237119_(), new ResourceLocation("custommachinery", "textures/gui/creation/delete_icon.png"), button -> this.delete(), (button, matrix, mouseX, mouseY) -> {
            Component tooltip = this.selectedMachine == null ? null : (this.selectedMachine.getLocation().getLoader() == MachineLocation.Loader.DATAPACK ? null : null);
            this.m_96602_(matrix, tooltip, mouseX, mouseY);
        }));
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        this.machineList.m_6305_(matrix, mouseX, mouseY, partialTicks);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (this.selectedMachine != null && this.machineCreationScreens.containsKey(this.selectedMachine)) {
            this.machineCreationScreens.get(this.selectedMachine).m_6305_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public void m_7333_(PoseStack matrix) {
        super.m_7333_(matrix);
        ClientHandler.bindTexture(BACKGROUND_TEXTURE);
        MachineLoadingScreen.m_93133_((PoseStack)matrix, (int)this.xPos, (int)this.yPos, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)this.xSize, (int)this.ySize);
    }

    protected void setSelectedMachine(CustomMachineBuilder machine) {
        if (this.selectedMachine != null && this.machineCreationScreens.containsKey(this.selectedMachine)) {
            this.m_6702_().remove((Object)this.machineCreationScreens.get(this.selectedMachine));
        }
        this.selectedMachine = machine;
        if (this.selectedMachine != null && this.machineCreationScreens.containsKey(this.selectedMachine)) {
            this.m_6702_().add((GuiEventListener)this.machineCreationScreens.get(this.selectedMachine));
        }
    }

    private void create() {
        CustomMachineBuilder newMachine = new CustomMachineBuilder().setLocation(MachineLocation.fromDatapack(new ResourceLocation("custommachinery", "new_machine"), ""));
        MachineCreationScreen newMachineScreen = new MachineCreationScreen(newMachine);
        newMachineScreen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        this.machineCreationScreens.put(newMachine, newMachineScreen);
        this.machineList.setSelected((MachineList.MachineEntry)((Object)this.machineList.m_6702_().get(this.machineList.addMachineEntry(newMachine))));
    }

    private void save() {
        CustomMachine machineToSave;
        CustomMachine customMachine = machineToSave = this.machineList.m_93511_() == null ? null : ((MachineList.MachineEntry)this.machineList.m_93511_()).getMachineBuilder().build();
        if (machineToSave != null && machineToSave.getId() != null && machineToSave.getLocation().getLoader() == MachineLocation.Loader.DATAPACK) {
            if (machineToSave.getLocation().getPackName().equals("")) {
                return;
            }
            ResourceLocation id = machineToSave.getId();
            new CAddMachinePacket(id, machineToSave, true, true).sendToServer();
        }
    }

    private void delete() {
        CustomMachineBuilder machineToDelete;
        CustomMachineBuilder customMachineBuilder = machineToDelete = this.machineList.m_93511_() == null ? null : ((MachineList.MachineEntry)this.machineList.m_93511_()).getMachineBuilder();
        if (machineToDelete != null) {
            CustomMachinery.MACHINES.remove(machineToDelete.getLocation().getId());
            this.machineList.removeMachineEntry(machineToDelete);
            this.machineCreationScreens.remove(machineToDelete);
            if (machineToDelete.getLocation().getLoader() == MachineLocation.Loader.DATAPACK) {
                FileUtils.deleteMachineJSON(Minecraft.m_91087_().f_91074_.m_20194_(), machineToDelete.getLocation().getId());
            }
        }
    }

    public Map<ResourceLocation, CustomMachineBuilder> getBuilders() {
        HashMap<ResourceLocation, CustomMachineBuilder> builders = new HashMap<ResourceLocation, CustomMachineBuilder>();
        this.machineCreationScreens.keySet().forEach(builder -> builders.put(builder.getLocation().getId(), (CustomMachineBuilder)builder));
        return builders;
    }

    public boolean m_7043_() {
        return false;
    }
}

