/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.popup;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.custom.ButtonWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class ConfirmPopup
extends PopupScreen {
    public static final Component CONFIRM = Component.m_237115_((String)"custommachinery.gui.popup.confirm").m_130940_(ChatFormatting.GREEN);
    public static final Component CANCEL = Component.m_237115_((String)"custommachinery.gui.popup.cancel").m_130940_(ChatFormatting.RED);
    private final Runnable onConfirm;
    private final List<Component> text = new ArrayList<Component>();
    @Nullable
    private Runnable onCancel;

    public ConfirmPopup(int xSize, int ySize, Runnable onConfirm) {
        super(xSize, ySize);
        this.onConfirm = onConfirm;
        this.onCancel = null;
    }

    public ConfirmPopup cancelCallback(Runnable callback) {
        this.onCancel = callback;
        return this;
    }

    public ConfirmPopup text(Component ... components) {
        this.text.addAll(Arrays.asList(components));
        return this;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.addCustomWidget(new ButtonWidget(() -> this.getX() + this.xSize / 4 - 25, () -> this.getY() + this.ySize - 30, 50, 20).title(CANCEL, true).callback(button -> {
            if (this.onCancel != null) {
                this.onCancel.run();
            }
            this.close();
        }));
        this.addCustomWidget(new ButtonWidget(() -> this.getX() + (int)((double)this.xSize * 0.75) - 25, () -> this.getY() + this.ySize - 30, 50, 20).title(CONFIRM, true).callback(button -> {
            this.onConfirm.run();
            this.close();
        }));
    }

    @Override
    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        Font font = Minecraft.m_91087_().f_91062_;
        for (int i = 0; i < this.text.size(); ++i) {
            Component component = this.text.get(i);
            int width = font.m_92852_((FormattedText)component);
            int x = (this.xSize - width) / 2 + this.getX();
            font.m_92889_(pose, component, (float)x, (float)(this.getY() + i * 20 + 5), 0);
        }
    }
}

