/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.util.Color3F;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public class MachineList
extends ObjectSelectionList<MachineEntry> {
    private final Consumer<CustomMachineBuilder> onSelect;

    public MachineList(Minecraft minecraft, int width, int height, int x, int y, int entryHeight, Consumer<CustomMachineBuilder> onSelect) {
        super(minecraft, width, height, y, y + height, entryHeight);
        this.m_93507_(x);
        this.m_93488_(false);
        this.m_93496_(false);
        this.f_93394_ = false;
        this.m_93471_(true);
        this.onSelect = onSelect;
    }

    public void addMachine(CustomMachineBuilder builder) {
        this.m_7085_((AbstractSelectionList.Entry)new MachineEntry(builder, this));
    }

    public void removeMachine(CustomMachineBuilder builder) {
        this.m_6702_().removeIf(machineEntry -> machineEntry.machineBuilder == builder);
    }

    public void setSelected(CustomMachineBuilder selected) {
        for (MachineEntry entry : this.m_6702_()) {
            if (entry.machineBuilder != selected) continue;
            this.setSelected(entry);
        }
    }

    @Nullable
    public CustomMachineBuilder selected() {
        return this.m_93511_() == null ? null : ((MachineEntry)this.m_93511_()).machineBuilder;
    }

    public void setSelected(@Nullable MachineEntry selected) {
        super.m_6987_((AbstractSelectionList.Entry)selected);
        this.onSelect.accept(selected == null ? null : selected.machineBuilder);
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ - 6;
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        double s = Minecraft.m_91087_().m_91268_().m_85449_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85444_() / (int)s;
        RenderSystem.m_69488_((int)(this.f_93393_ * (int)s), (int)((screenHeight - this.f_93390_ - this.f_93389_) * (int)s), (int)(this.f_93388_ * (int)s), (int)(this.f_93389_ * (int)s));
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        RenderSystem.m_69471_();
    }

    public static class MachineEntry
    extends ObjectSelectionList.Entry<MachineEntry> {
        private final CustomMachineBuilder machineBuilder;
        private final MachineList machineList;

        public MachineEntry(CustomMachineBuilder machineBuilder, MachineList list) {
            this.machineBuilder = machineBuilder;
            this.machineList = list;
        }

        public void m_6311_(PoseStack pose, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isFocused, float partialTicks) {
            Color3F color = Color3F.of(100, 100, 100);
            if (this.machineList.m_93511_() == this) {
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BufferBuilder builder = Tesselator.m_85913_().m_85915_();
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                builder.m_85982_(pose.m_85850_().m_85861_(), (float)x, (float)(y + height), 0.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).m_5752_();
                builder.m_85982_(pose.m_85850_().m_85861_(), (float)(x + width), (float)(y + height), 0.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).m_5752_();
                builder.m_85982_(pose.m_85850_().m_85861_(), (float)(x + width), (float)y, 0.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).m_5752_();
                builder.m_85982_(pose.m_85850_().m_85861_(), (float)x, (float)y, 0.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).m_5752_();
                Tesselator.m_85913_().m_85914_();
            }
            if (this.machineBuilder != null) {
                int nameWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.machineBuilder.getName().getString());
                float scale = Mth.m_14036_((float)((float)(width - 8) / (float)nameWidth), (float)0.0f, (float)0.8f);
                pose.m_85836_();
                pose.m_85837_((double)(x + 2), (double)(y + 2), 0.0);
                pose.m_85841_(scale, scale, 0.0f);
                Minecraft.m_91087_().f_91062_.m_92889_(pose, this.machineBuilder.getName(), 0.0f, 0.0f, DyeColor.RED.m_41060_());
                pose.m_85841_(0.8f, 0.8f, 0.0f);
                Minecraft.m_91087_().f_91062_.m_92883_(pose, this.machineBuilder.getLocation().getLoader().getTranslatedName().getString(), 0.0f, 11.0f, this.machineBuilder.getLocation().getLoader().getColor());
                pose.m_85849_();
            } else {
                Minecraft.m_91087_().f_91062_.m_92883_(pose, "NULL", (float)x, (float)y, 0);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.machineList.setSelected(this);
            return true;
        }

        public Component m_142172_() {
            if (this.machineBuilder != null) {
                return this.machineBuilder.getName();
            }
            return Component.m_237113_((String)"NULL");
        }

        public CustomMachineBuilder getMachineBuilder() {
            return this.machineBuilder;
        }
    }
}

