/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.client.screen.widget.custom.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ButtonWidget
extends Widget {
    private Component title = Component.m_237119_();
    private boolean displayTitle = false;
    private Consumer<ButtonWidget> onPress = button -> {};
    private ResourceLocation texture = null;
    private int u = 0;
    private int v = 0;
    private int uWidth;
    private int vHeight;
    private ResourceLocation hoverTexture = null;
    private int hoverU = 0;
    private int hoverV = 0;
    private int hoverUWidth;
    private int hoverVHeight;
    private boolean background = true;
    private final List<Component> tooltips = new ArrayList<Component>();

    public ButtonWidget(Supplier<Integer> x, Supplier<Integer> y, int width, int height) {
        super(x, y, width, height);
        this.uWidth = width;
        this.vHeight = height;
        this.hoverUWidth = width;
        this.hoverVHeight = height;
    }

    public ButtonWidget title(Component title, boolean display) {
        this.title = title;
        this.displayTitle = display;
        return this;
    }

    public ButtonWidget callback(Consumer<ButtonWidget> onPress) {
        this.onPress = onPress;
        return this;
    }

    public ButtonWidget texture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public ButtonWidget texture(ResourceLocation texture, int u, int v) {
        this.u = u;
        this.v = v;
        return this.texture(texture);
    }

    public ButtonWidget texture(ResourceLocation texture, int u, int v, int uWidth, int vHeight) {
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        return this.texture(texture, u, v);
    }

    public ButtonWidget hoverTexture(ResourceLocation texture) {
        this.hoverTexture = texture;
        return this;
    }

    public ButtonWidget hoverTexture(ResourceLocation texture, int u, int v) {
        this.hoverU = u;
        this.hoverV = v;
        return this.hoverTexture(texture);
    }

    public ButtonWidget hoverTexture(ResourceLocation texture, int u, int v, int uWidth, int vHeight) {
        this.hoverUWidth = uWidth;
        this.hoverVHeight = vHeight;
        return this.hoverTexture(texture, u, v);
    }

    public ButtonWidget noBackground() {
        this.background = false;
        return this;
    }

    public ButtonWidget tooltip(Component tooltip) {
        this.tooltips.add(tooltip);
        return this;
    }

    @Override
    public void render(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        if (this.background) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractWidget.f_93617_);
            int i = this.m_5953_(mouseX, mouseY) ? 2 : 1;
            AbstractWidget.m_93143_((PoseStack)pose, (int)this.getX(), (int)this.getY(), (int)0, (float)0.0f, (float)(46 + i * 20), (int)(this.width / 2), (int)this.height, (int)256, (int)256);
            AbstractWidget.m_93143_((PoseStack)pose, (int)(this.getX() + this.width / 2), (int)this.getY(), (int)0, (float)(200.0f - (float)this.width / 2.0f), (float)(46 + i * 20), (int)(this.width / 2), (int)this.height, (int)256, (int)256);
        }
        if (!this.m_5953_(mouseX, mouseY)) {
            if (this.texture != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
                AbstractWidget.m_93160_((PoseStack)pose, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (float)this.u, (float)this.v, (int)this.uWidth, (int)this.vHeight, (int)this.width, (int)this.height);
            }
        } else if (this.hoverTexture != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.hoverTexture);
            AbstractWidget.m_93160_((PoseStack)pose, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (float)this.hoverU, (float)this.hoverV, (int)this.hoverUWidth, (int)this.hoverVHeight, (int)this.width, (int)this.height);
        } else if (this.texture != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
            AbstractWidget.m_93160_((PoseStack)pose, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (float)this.u, (float)this.v, (int)this.uWidth, (int)this.vHeight, (int)this.width, (int)this.height);
        }
        if (this.displayTitle && this.title != null && !this.title.getString().isEmpty()) {
            Font font = Minecraft.m_91087_().f_91062_;
            int x = this.getX() + (this.width - font.m_92852_((FormattedText)this.title)) / 2;
            int n = this.getY();
            Objects.requireNonNull(font);
            int y = n + (this.height - 9) / 2;
            font.m_92889_(pose, this.title, (float)x, (float)y, 0);
        }
    }

    @Override
    public List<Component> getTooltips() {
        return this.tooltips;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY) && button == 0) {
            this.onPress.accept(this);
            this.playDownSound();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

