/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fr.frinn.custommachinery.client.screen.widget.custom.Widget;
import fr.frinn.custommachinery.common.util.Color3F;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class ListWidget<T, E extends Entry<T>>
extends Widget {
    private final List<E> entries = new ArrayList();
    private Consumer<T> callback = null;
    private int scrollbarOffsetX;
    private int scrollbarOffsetY;
    private int entryHeight = 20;
    @Nullable
    private E selected = null;
    private double scrollAmount = 0.0;
    private boolean scrolling = false;

    public ListWidget(Supplier<Integer> x, Supplier<Integer> y, int width, int height) {
        super(x, y, width, height);
        this.scrollbarOffsetX = width - 6;
        this.scrollbarOffsetY = 0;
    }

    public ListWidget<T, E> selectionCallback(Consumer<T> callback) {
        this.callback = callback;
        return this;
    }

    public ListWidget<T, E> scrollbarOffset(int x, int y) {
        this.scrollbarOffsetX = x;
        this.scrollbarOffsetY = y;
        return this;
    }

    public ListWidget<T, E> entryHeight(int height) {
        this.entryHeight = 20;
        return this;
    }

    public abstract void add(T var1);

    public void add(E entry) {
        this.entries.add(entry);
    }

    public void remove(T value) {
        this.entries.removeIf(entry -> entry.getValue() == value);
        if (this.selected == value) {
            this.selected = null;
        }
    }

    public void setSelected(E entry) {
        this.selected = entry;
        if (this.callback != null) {
            this.callback.accept(((Entry)entry).getValue());
        }
    }

    public void setSelected(T value) {
        for (Entry entry : this.entries) {
            if (entry.getValue() != value) continue;
            this.selected = entry;
        }
    }

    @Nullable
    public T getSelected() {
        return this.selected == null ? null : (T)((Entry)this.selected).getValue();
    }

    public int getMaxScroll() {
        return Math.max(0, this.entries.size() * this.entryHeight - this.height);
    }

    @Nullable
    protected final E getEntryAtPosition(double mouseX, double mouseY) {
        int x = this.getX();
        int y = Mth.m_14107_((double)(mouseY - (double)this.getY())) + (int)this.scrollAmount - 4;
        int index = y / this.entryHeight;
        return (E)(mouseX < (double)(this.getX() + this.scrollbarOffsetX) && mouseX >= (double)x && mouseX <= (double)(x + this.width) && index >= 0 && y >= 0 && index < this.entries.size() ? (Entry)this.entries.get(index) : null);
    }

    @Override
    public void render(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        double s = Minecraft.m_91087_().m_91268_().m_85449_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85444_() / (int)s;
        RenderSystem.m_69488_((int)(this.getX() * (int)s), (int)((screenHeight - this.getY() - this.height) * (int)s), (int)(this.width * (int)s), (int)(this.height * (int)s));
        this.renderEntries(pose, mouseX, mouseY, partialTicks);
        this.renderScrollbar(pose, this.getX() + this.scrollbarOffsetX, this.getY() + this.scrollbarOffsetY, 6, this.height, partialTicks);
        RenderSystem.m_69471_();
    }

    private void renderEntries(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.entries.size(); ++i) {
            int x = this.getX();
            int y = this.getY() + (int)this.scrollAmount + i * this.entryHeight;
            if ((y < this.getY() || y > this.getY() + this.height) && (y + this.entryHeight < this.getY() || y + this.entryHeight > this.getY() + this.height)) continue;
            Entry entry = (Entry)this.entries.get(i);
            if (this.selected == entry) {
                this.renderSelection(pose, x, y, partialTicks);
            }
            entry.render(pose, x, y, this.width, this.entryHeight, mouseX, mouseY, partialTicks);
        }
    }

    private void renderSelection(PoseStack pose, int x, int y, float partialTicks) {
        Color3F color = Color3F.of(100, 100, 100);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_85982_(pose.m_85850_().m_85861_(), (float)x, (float)(y + this.entryHeight), 0.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).m_5752_();
        builder.m_85982_(pose.m_85850_().m_85861_(), (float)(x + this.width), (float)(y + this.entryHeight), 0.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).m_5752_();
        builder.m_85982_(pose.m_85850_().m_85861_(), (float)(x + this.width), (float)y, 0.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).m_5752_();
        builder.m_85982_(pose.m_85850_().m_85861_(), (float)x, (float)y, 0.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    private void renderScrollbar(PoseStack pose, int x, int y, int width, int height, float partialTicks) {
        int maxScroll = this.getMaxScroll();
        if (maxScroll <= 0) {
            return;
        }
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        int barTop = height * height / (this.entries.size() * this.entryHeight);
        barTop = Mth.m_14045_((int)barTop, (int)32, (int)(height - 8));
        int barBottom = (int)this.scrollAmount * (height - barTop) / maxScroll + y;
        if (barBottom < y) {
            barBottom = y;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_5483_((double)x, (double)(y + height), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_5483_((double)(x + width), (double)(y + height), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_5483_((double)(x + width), (double)y, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_5483_((double)x, (double)y, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_5483_((double)x, (double)(barBottom + barTop), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
        builder.m_5483_((double)(x + width), (double)(barBottom + barTop), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
        builder.m_5483_((double)(x + width), (double)barBottom, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
        builder.m_5483_((double)x, (double)barBottom, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
        builder.m_5483_((double)x, (double)(barBottom + barTop - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
        builder.m_5483_((double)(x + width - 1), (double)(barBottom + barTop - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
        builder.m_5483_((double)(x + width - 1), (double)barBottom, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
        builder.m_5483_((double)x, (double)barBottom, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
        tesselator.m_85914_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl = this.scrolling = button == 0 && mouseX >= (double)(this.getX() + this.scrollbarOffsetX) && mouseX <= (double)(this.getX() + this.scrollbarOffsetX + 6);
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null) {
            this.setSelected((T)entry);
        }
        return this.scrolling;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.getY()) {
                this.scrollAmount = 0.0;
            } else if (mouseY > (double)(this.getY() + this.height)) {
                this.scrollAmount = this.getMaxScroll();
            } else {
                double d = Math.max(1, this.getMaxScroll());
                int j = Mth.m_14045_((int)(this.height * this.height / (this.entries.size() * this.entryHeight)), (int)32, (int)(this.height - 8));
                double e = Math.max(1.0, d / (double)(this.height - j));
                this.scrollAmount += dragY * e;
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollAmount -= delta * (double)this.entryHeight / 2.0;
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 264) {
            this.scrollAmount -= 20.0;
            return true;
        }
        if (keyCode == 265) {
            this.scrollAmount += 20.0;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public static abstract class Entry<T> {
        private final T value;

        public Entry(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public abstract void render(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);
    }
}

