/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget.custom.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.screen.widget.custom.Widget;
import fr.frinn.custommachinery.common.network.CChangeSideModePacket;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class AutoIOModeButtonWidget
extends Widget {
    private static final ResourceLocation TEXTURE = new ResourceLocation("custommachinery", "textures/gui/config/auto_io_mode.png");
    private static final Component INPUT = Component.m_237115_((String)"custommachinery.gui.config.auto_input");
    private static final Component OUTPUT = Component.m_237115_((String)"custommachinery.gui.config.auto_output");
    private static final Component ENABLED = Component.m_237115_((String)"custommachinery.gui.config.enabled").m_130940_(ChatFormatting.GREEN);
    private static final Component DISABLED = Component.m_237115_((String)"custommachinery.gui.config.disabled").m_130940_(ChatFormatting.RED);
    private final SideConfig config;
    private final boolean input;

    public AutoIOModeButtonWidget(Supplier<Integer> x, Supplier<Integer> y, SideConfig config, boolean input) {
        super(x, y, 28, 14);
        this.config = config;
        this.input = input;
    }

    @Override
    public void render(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        ClientHandler.bindTexture(TEXTURE);
        int color = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
        if (this.input && this.config.isAutoInput()) {
            color = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)85, (int)85);
        } else if (!this.input && this.config.isAutoOutput()) {
            color = FastColor.ARGB32.m_13660_((int)255, (int)85, (int)85, (int)255);
        }
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        if (this.m_5953_(mouseX, mouseY)) {
            GuiComponent.m_93133_((PoseStack)pose, (int)this.getX(), (int)this.getY(), (float)0.0f, (float)14.0f, (int)this.width, (int)this.height, (int)this.width, (int)28);
        } else {
            GuiComponent.m_93133_((PoseStack)pose, (int)this.getX(), (int)this.getY(), (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)28);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public List<Component> getTooltips() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add(this.input ? INPUT : OUTPUT);
        if (this.input && this.config.isAutoInput() || !this.input && this.config.isAutoOutput()) {
            tooltips.add(ENABLED);
        } else {
            tooltips.add(DISABLED);
        }
        return tooltips;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.playDownSound();
            if (Minecraft.m_91087_().f_91074_ == null) {
                return true;
            }
            new CChangeSideModePacket(Minecraft.m_91087_().f_91074_.f_36096_.f_38840_, this.getComponentId(), (byte)(this.input ? 6 : 7), true).sendToServer();
            return true;
        }
        return false;
    }

    private String getComponentId() {
        return this.config.getComponent().getType().getId().toString() + ":" + this.config.getComponent().getId();
    }
}

