/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget.custom.config;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.screen.widget.custom.Widget;
import fr.frinn.custommachinery.common.network.CChangeSideModePacket;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class SideModeButtonWidget
extends Widget {
    private static final ResourceLocation TEXTURE = new ResourceLocation("custommachinery", "textures/gui/config/side_mode.png");
    private final SideConfig config;
    private final RelativeSide side;

    public SideModeButtonWidget(Supplier<Integer> x, Supplier<Integer> y, SideConfig config, RelativeSide side) {
        super(x, y, 14, 14);
        this.config = config;
        this.side = side;
    }

    @Override
    public void render(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        ClientHandler.bindTexture(TEXTURE);
        int color = this.config.getSideMode(this.side).color();
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        if (this.m_5953_(mouseX, mouseY)) {
            GuiComponent.m_93133_((PoseStack)pose, (int)this.getX(), (int)this.getY(), (float)0.0f, (float)14.0f, (int)this.width, (int)this.height, (int)this.width, (int)28);
        } else {
            GuiComponent.m_93133_((PoseStack)pose, (int)this.getX(), (int)this.getY(), (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)28);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public List<Component> getTooltips() {
        return Lists.newArrayList((Object[])new Component[]{this.side.getTranslationName(), this.config.getSideMode(this.side).title()});
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.playDownSound();
        if (Minecraft.m_91087_().f_91074_ == null) {
            return true;
        }
        if (button == 0) {
            new CChangeSideModePacket(Minecraft.m_91087_().f_91074_.f_36096_.f_38840_, this.getComponentId(), (byte)this.side.ordinal(), true).sendToServer();
        } else {
            new CChangeSideModePacket(Minecraft.m_91087_().f_91074_.f_36096_.f_38840_, this.getComponentId(), (byte)this.side.ordinal(), false).sendToServer();
        }
        return true;
    }

    private String getComponentId() {
        return this.config.getComponent().getType().getId().toString() + ":" + this.config.getComponent().getId();
    }
}

