/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;

public class BlockMachineComponent
extends AbstractMachineComponent {
    public BlockMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.BOTH);
    }

    public MachineComponentType<BlockMachineComponent> getType() {
        return (MachineComponentType)Registration.BLOCK_MACHINE_COMPONENT.get();
    }

    public long getBlockAmount(AABB box, List<IIngredient<PartialBlockState>> filter, boolean whitelist) {
        box = Utils.rotateBox(box, (Direction)this.getManager().getTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
        box = box.m_82338_(this.getManager().getTile().m_58899_());
        return BlockPos.m_121921_((AABB)box).map(pos -> new BlockInWorld((LevelReader)this.getManager().getLevel(), pos, false)).filter(block -> filter.stream().flatMap(ingredient -> ingredient.getAll().stream()).anyMatch(state -> state.test((BlockInWorld)block)) == whitelist).count();
    }

    public boolean placeBlock(AABB box, PartialBlockState block, int amount) {
        box = Utils.rotateBox(box, (Direction)this.getManager().getTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
        box = box.m_82338_(this.getManager().getTile().m_58899_());
        if (BlockPos.m_121921_((AABB)box).map(arg_0 -> ((Level)this.getManager().getLevel()).m_8055_(arg_0)).filter(state -> state.m_60734_() == Blocks.f_50016_).count() < (long)amount) {
            return false;
        }
        AtomicInteger toPlace = new AtomicInteger(amount);
        BlockPos.m_121921_((AABB)box).forEach(pos -> {
            if (toPlace.get() > 0 && this.getManager().getLevel().m_8055_(pos).m_60734_() == Blocks.f_50016_) {
                this.setBlock(this.getManager().getLevel(), (BlockPos)pos, block);
                toPlace.addAndGet(-1);
            }
        });
        return true;
    }

    public boolean replaceBlock(AABB box, PartialBlockState block, int amount, boolean drop, List<IIngredient<PartialBlockState>> filter, boolean whitelist) {
        if (this.getBlockAmount(box, filter, whitelist) < (long)amount) {
            return false;
        }
        box = Utils.rotateBox(box, (Direction)this.getManager().getTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
        box = box.m_82338_(this.getManager().getTile().m_58899_());
        AtomicInteger toPlace = new AtomicInteger(amount);
        BlockPos.m_121921_((AABB)box).forEach(pos -> {
            if (toPlace.get() > 0) {
                BlockInWorld cached = new BlockInWorld((LevelReader)this.getManager().getLevel(), pos, false);
                if (filter.stream().flatMap(ingredient -> ingredient.getAll().stream()).anyMatch(state -> state.test(cached)) == whitelist) {
                    if (cached.m_61168_().m_60767_() != Material.f_76296_) {
                        this.getManager().getLevel().m_46961_(pos, drop);
                    }
                    this.setBlock(this.getManager().getLevel(), (BlockPos)pos, block);
                    toPlace.addAndGet(-1);
                }
            }
        });
        return true;
    }

    public boolean breakBlock(AABB box, List<IIngredient<PartialBlockState>> filter, boolean whitelist, int amount, boolean drop) {
        if (this.getBlockAmount(box, filter, whitelist) < (long)amount) {
            return false;
        }
        box = Utils.rotateBox(box, (Direction)this.getManager().getTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
        box = box.m_82338_(this.getManager().getTile().m_58899_());
        AtomicInteger toPlace = new AtomicInteger(amount);
        BlockPos.m_121921_((AABB)box).forEach(pos -> {
            if (toPlace.get() > 0) {
                BlockInWorld cached = new BlockInWorld((LevelReader)this.getManager().getLevel(), pos, false);
                if (filter.stream().flatMap(ingredient -> ingredient.getAll().stream()).anyMatch(state -> state.test(cached)) == whitelist) {
                    if (cached.m_61168_().m_60767_() != Material.f_76296_) {
                        this.getManager().getLevel().m_46961_(pos, drop);
                    }
                    toPlace.addAndGet(-1);
                }
            }
        });
        return true;
    }

    private void setBlock(Level world, BlockPos pos, PartialBlockState state) {
        world.m_46597_(pos, state.getBlockState());
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && state.getNbt() != null && !state.getNbt().m_128456_()) {
            CompoundTag nbt = state.getNbt().m_6426_();
            nbt.m_128405_("x", pos.m_123341_());
            nbt.m_128405_("y", pos.m_123342_());
            nbt.m_128405_("z", pos.m_123343_());
            tile.m_142466_(nbt);
        }
    }
}

