/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class DropMachineComponent
extends AbstractMachineComponent {
    public DropMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.BOTH);
    }

    public MachineComponentType<DropMachineComponent> getType() {
        return (MachineComponentType)Registration.DROP_MACHINE_COMPONENT.get();
    }

    public int getItemAmount(List<IIngredient<Item>> items, double radius, boolean whitelist) {
        List filter = items.stream().flatMap(ingredient -> ingredient.getAll().stream()).toList();
        AABB box = new AABB(this.getManager().getTile().m_58899_().m_7637_(radius, radius, radius), this.getManager().getTile().m_58899_().m_7637_(-radius, -radius, -radius));
        return this.getManager().getLevel().m_6443_(ItemEntity.class, box, entity -> filter.contains(entity.m_32055_().m_41720_()) == whitelist && entity.m_20183_().m_123314_((Vec3i)this.getManager().getTile().m_58899_(), radius)).stream().mapToInt(entity -> entity.m_32055_().m_41613_()).sum();
    }

    public void consumeItem(List<IIngredient<Item>> items, int amount, double radius, boolean whitelist) {
        List filter = items.stream().flatMap(ingredient -> ingredient.getAll().stream()).toList();
        AtomicInteger toRemove = new AtomicInteger(amount);
        AABB box = new AABB(this.getManager().getTile().m_58899_().m_7637_(radius, radius, radius), this.getManager().getTile().m_58899_().m_7637_(-radius, -radius, -radius));
        this.getManager().getLevel().m_6443_(ItemEntity.class, box, entity -> filter.contains(entity.m_32055_().m_41720_()) == whitelist && entity.m_20183_().m_123314_((Vec3i)this.getManager().getTile().m_58899_(), radius)).forEach(entity -> {
            int maxRemove = Math.min(toRemove.get(), entity.m_32055_().m_41613_());
            if (maxRemove == entity.m_32055_().m_41613_()) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                entity.m_32055_().m_41774_(maxRemove);
            }
            toRemove.addAndGet(-maxRemove);
        });
    }

    public boolean produceItem(ItemStack stack) {
        Level world = this.getManager().getLevel();
        BlockPos pos = this.getManager().getTile().m_58899_().m_7494_();
        ItemEntity entity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
        return world.m_7967_((Entity)entity);
    }
}

