/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.IVariableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.component.variant.IComponentVariant;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.variant.item.DefaultItemComponentVariant;
import fr.frinn.custommachinery.common.component.variant.item.FilterItemComponentVariant;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.ItemStackSyncable;
import fr.frinn.custommachinery.common.network.syncable.SideConfigSyncable;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinery.impl.component.variant.ItemComponentVariant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class ItemMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
IVariableComponent<ItemComponentVariant>,
ISideConfigComponent {
    private final String id;
    private final int capacity;
    private final int maxInput;
    private final int maxOutput;
    private final List<IIngredient<Item>> filter;
    private final boolean whitelist;
    private ItemStack stack = ItemStack.f_41583_;
    private final ItemComponentVariant variant;
    private final SideConfig config;
    private boolean locked;

    public ItemMachineComponent(IMachineComponentManager manager, ComponentIOMode mode, String id, int capacity, int maxInput, int maxOutput, List<IIngredient<Item>> filter, boolean whitelist, ItemComponentVariant variant, SideConfig.Template configTemplate, boolean locked) {
        super(manager, mode);
        this.id = id;
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.filter = filter;
        this.whitelist = whitelist;
        this.variant = variant;
        this.config = this.variant == FilterItemComponentVariant.INSTANCE ? SideConfig.Template.DEFAULT_ALL_NONE_DISABLED.build(this) : configTemplate.build(this);
        this.locked = locked;
    }

    public MachineComponentType<ItemMachineComponent> getType() {
        return (MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SideConfig getConfig() {
        return this.config;
    }

    @Override
    public ItemComponentVariant getVariant() {
        return this.variant;
    }

    public boolean isItemValid(ItemStack stack) {
        return this.filter.stream().anyMatch(ingredient -> ingredient.test(stack.m_41720_())) == this.whitelist && this.variant.canAccept(this.getManager(), stack);
    }

    public int getRemainingSpace() {
        if (!this.stack.m_41619_()) {
            return this.capacity - this.stack.m_41613_();
        }
        return this.capacity;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int insert(Item item, int amount, @Nullable CompoundTag nbt, boolean simulate) {
        return this.insert(item, amount, nbt, simulate, false);
    }

    public int insert(Item item, int amount, @Nullable CompoundTag nbt, boolean simulate, boolean byPassLimit) {
        if (amount <= 0 || item == Items.f_41852_ || !this.isItemValid(Utils.makeItemStack(item, amount, nbt))) {
            return 0;
        }
        if (!byPassLimit) {
            amount = Math.min(amount, this.maxInput);
        }
        amount = Math.min(amount, Utils.makeItemStack(item, amount, nbt).m_41741_());
        amount = Math.min(amount, this.stack.m_41741_() - this.stack.m_41613_());
        amount = Math.min(amount, this.capacity - this.stack.m_41613_());
        if (this.stack.m_41619_()) {
            if (!simulate) {
                this.stack = Utils.makeItemStack(item, amount, nbt);
                this.getManager().markDirty();
                this.getManager().getTile().getUpgradeManager().markDirty();
            }
            return amount;
        }
        if (this.stack.m_41720_() == item && (this.stack.m_41783_() == null || this.stack.m_41783_().equals((Object)nbt))) {
            amount = Math.min(this.getRemainingSpace(), amount);
            if (!simulate) {
                this.stack.m_41769_(amount);
                this.getManager().markDirty();
                this.getManager().getTile().getUpgradeManager().markDirty();
            }
            return amount;
        }
        return 0;
    }

    public ItemStack extract(int amount, boolean simulate) {
        return this.extract(amount, simulate, false);
    }

    public ItemStack extract(int amount, boolean simulate, boolean byPassLimit) {
        if (amount <= 0 || this.stack.m_41619_() || !this.variant.canOutput(this.getManager())) {
            return ItemStack.f_41583_;
        }
        if (!byPassLimit) {
            amount = Math.min(amount, this.maxOutput);
        }
        amount = Math.min(amount, this.stack.m_41613_());
        ItemStack removed = Utils.makeItemStack(this.stack.m_41720_(), amount, this.stack.m_41783_());
        if (!simulate) {
            this.stack.m_41774_(amount);
            this.getManager().markDirty();
            this.getManager().getTile().getUpgradeManager().markDirty();
        }
        return removed;
    }

    public void setItemStack(ItemStack stack) {
        this.stack = stack;
        this.getManager().markDirty();
        this.getManager().getTile().getUpgradeManager().markDirty();
    }

    public boolean isLocked() {
        return this.locked || this.variant == FilterItemComponentVariant.INSTANCE;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void serialize(CompoundTag nbt) {
        if (!this.stack.m_41619_()) {
            this.stack.m_41739_(nbt);
        }
        nbt.m_128365_("config", this.config.serialize());
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt);
        if (nbt.m_128441_("config")) {
            this.config.deserialize(nbt.m_128423_("config"));
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(ItemStackSyncable.create(() -> this.stack, stack -> {
            this.stack = stack;
        }));
        container.accept(SideConfigSyncable.create(this::getConfig, this.config::set));
    }

    @Override
    public int getComparatorInput() {
        return AbstractContainerMenu.m_38938_((Container)new SimpleContainer(new ItemStack[]{this.stack}));
    }

    public static class Template
    implements IMachineComponentTemplate<ItemMachineComponent> {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(itemMachineComponentTemplate -> itemMachineComponentTemplate.group(NamedCodec.STRING.fieldOf("id").forGetter(template -> template.id), ComponentIOMode.CODEC.optionalFieldOf("mode", ComponentIOMode.BOTH).forGetter(template -> template.mode), NamedCodec.INT.optionalFieldOf("capacity", 64).forGetter(template -> template.capacity), NamedCodec.INT.optionalFieldOf("max_input").forGetter(template -> Optional.of(template.maxInput)), NamedCodec.INT.optionalFieldOf("max_output").forGetter(template -> Optional.of(template.maxOutput)), IIngredient.ITEM.listOf().optionalFieldOf("filter", Collections.emptyList()).forGetter(template -> template.filter), NamedCodec.BOOL.optionalFieldOf("whitelist", false).forGetter(template -> template.whitelist), IComponentVariant.codec(Registration.ITEM_MACHINE_COMPONENT).orElse(DefaultItemComponentVariant.INSTANCE).forGetter(template -> template.variant), SideConfig.Template.CODEC.optionalFieldOf("config").forGetter(template -> Optional.of(template.config)), NamedCodec.BOOL.optionalFieldOf("locked", false).aliases("lock").forGetter(template -> template.locked)).apply((Applicative)itemMachineComponentTemplate, (id, mode, capacity, maxInput, maxOutput, filter, whitelist, variant, config, locked) -> new Template((String)id, (ComponentIOMode)((Object)((Object)mode)), (int)capacity, maxInput.orElse(capacity), maxOutput.orElse(capacity), (List<IIngredient<Item>>)filter, (boolean)whitelist, (ItemComponentVariant)variant, config.orElse(mode.getBaseConfig()), (boolean)locked)), "Item machine component");
        private final ComponentIOMode mode;
        private final String id;
        private final int capacity;
        private final int maxInput;
        private final int maxOutput;
        private final List<IIngredient<Item>> filter;
        private final boolean whitelist;
        private final ItemComponentVariant variant;
        private final SideConfig.Template config;
        private final boolean locked;

        public Template(String id, ComponentIOMode mode, int capacity, int maxInput, int maxOutput, List<IIngredient<Item>> filter, boolean whitelist, ItemComponentVariant variant, SideConfig.Template config, boolean locked) {
            this.mode = mode;
            this.id = id;
            this.capacity = capacity;
            this.maxInput = maxInput;
            this.maxOutput = maxOutput;
            this.filter = filter;
            this.whitelist = whitelist;
            this.variant = variant;
            this.config = config;
            this.locked = locked;
        }

        public ItemComponentVariant getVariant() {
            return this.variant;
        }

        @Override
        public MachineComponentType<ItemMachineComponent> getType() {
            return (MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            if (this.mode != ComponentIOMode.BOTH && isInput != this.mode.isInput()) {
                return false;
            }
            if (ingredient instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                return this.filter.stream().flatMap(i -> i.getAll().stream()).anyMatch(i -> i == stack.m_41720_()) == this.whitelist && this.variant.canAccept(manager, stack);
            }
            if (ingredient instanceof List) {
                List list = (List)ingredient;
                return list.stream().allMatch(object -> {
                    if (object instanceof ItemStack) {
                        ItemStack stack = (ItemStack)object;
                        return this.filter.stream().flatMap(i -> i.getAll().stream()).anyMatch(i -> i == stack.m_41720_()) == this.whitelist && this.variant.canAccept(manager, stack);
                    }
                    return false;
                });
            }
            return false;
        }

        @Override
        public ItemMachineComponent build(IMachineComponentManager manager) {
            return new ItemMachineComponent(manager, this.mode, this.id, this.capacity, this.maxInput, this.maxOutput, this.filter, this.whitelist, this.variant, this.config, this.locked);
        }
    }
}

