/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component.handler;

import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.component.IDumpComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.component.variant.ITickableComponentVariant;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.component.variant.item.FilterItemComponentVariant;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.transfer.ICommonItemHandler;
import fr.frinn.custommachinery.impl.component.AbstractComponentHandler;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class ItemComponentHandler
extends AbstractComponentHandler<ItemMachineComponent>
implements ISerializableComponent,
ITickableComponent,
ISyncableStuff,
IDumpComponent {
    private final RandomSource rand = RandomSource.m_216327_();
    private final List<ItemMachineComponent> tickableVariants;
    private final ICommonItemHandler handler = PlatformHelper.createItemHandler(this);
    private final List<ItemMachineComponent> inputs = new ArrayList<ItemMachineComponent>();
    private final List<ItemMachineComponent> outputs = new ArrayList<ItemMachineComponent>();

    public ItemComponentHandler(IMachineComponentManager manager, List<ItemMachineComponent> components) {
        super(manager, components);
        components.forEach(component -> {
            component.getConfig().setCallback((TriConsumer<RelativeSide, SideMode, SideMode>)((TriConsumer)this.handler::configChanged));
            if (component.getVariant() != FilterItemComponentVariant.INSTANCE) {
                if (component.getMode().isInput()) {
                    this.inputs.add((ItemMachineComponent)component);
                }
                if (component.getMode().isOutput()) {
                    this.outputs.add((ItemMachineComponent)component);
                }
            }
        });
        this.tickableVariants = components.stream().filter(component -> component.getVariant() instanceof ITickableComponentVariant).toList();
    }

    public ICommonItemHandler getCommonHandler() {
        return this.handler;
    }

    public MachineComponentType<ItemMachineComponent> getType() {
        return (MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get();
    }

    @Override
    public void onRemoved() {
        this.handler.invalidate();
    }

    @Override
    public Optional<ItemMachineComponent> getComponentForID(String id) {
        return this.getComponents().stream().filter(component -> component.getId().equals(id)).findFirst();
    }

    @Override
    public void serialize(CompoundTag nbt) {
        ListTag components = new ListTag();
        this.getComponents().forEach(component -> {
            CompoundTag componentNBT = new CompoundTag();
            component.serialize(componentNBT);
            componentNBT.m_128359_("slotID", component.getId());
            components.add((Object)componentNBT);
        });
        nbt.m_128365_("items", (Tag)components);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        if (nbt.m_128425_("items", 9)) {
            ListTag components = nbt.m_128437_("items", 10);
            components.forEach(inbt -> {
                CompoundTag componentNBT;
                if (inbt instanceof CompoundTag && (componentNBT = (CompoundTag)inbt).m_128425_("slotID", 8)) {
                    this.getComponents().stream().filter(component -> component.getId().equals(componentNBT.m_128461_("slotID"))).findFirst().ifPresent(component -> component.deserialize(componentNBT));
                }
            });
        }
    }

    @Override
    public void serverTick() {
        this.handler.tick();
        this.tickableVariants.forEach(component -> ((ITickableComponentVariant)((Object)component.getVariant())).tick(component));
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.getComponents().forEach(component -> component.getStuffToSync(container));
    }

    @Override
    public void dump(List<String> ids) {
        this.getComponents().stream().filter(component -> ids.contains(component.getId())).forEach(component -> component.setItemStack(ItemStack.f_41583_));
    }

    public int getItemAmount(String slot, Item item, @Nullable CompoundTag nbt) {
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.m_128456_() || component.getItemStack().m_41783_() != null && Utils.testNBT(component.getItemStack().m_41783_(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        return this.inputs.stream().filter(component -> component.getItemStack().m_41720_() == item && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).mapToInt(component -> component.getItemStack().m_41613_()).sum();
    }

    public int getDurabilityAmount(String slot, Item item, @Nullable CompoundTag nbt) {
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.m_128456_() || component.getItemStack().m_41783_() != null && Utils.testNBT(component.getItemStack().m_41783_(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        return this.inputs.stream().filter(component -> component.getItemStack().m_41720_() == item && component.getItemStack().m_41763_() && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).mapToInt(component -> component.getItemStack().m_41776_() - component.getItemStack().m_41773_()).sum();
    }

    public int getSpaceForItem(String slot, Item item, @Nullable CompoundTag nbt) {
        int maxStackSize = Utils.makeItemStack(item, 1, nbt).m_41741_();
        return this.outputs.stream().filter(component -> this.canPlaceOutput((ItemMachineComponent)component, slot, item, nbt)).mapToInt(component -> {
            if (component.getItemStack().m_41619_()) {
                return Math.min(component.getCapacity(), maxStackSize);
            }
            return Math.min(component.getCapacity() - component.getItemStack().m_41613_(), maxStackSize - component.getItemStack().m_41613_());
        }).sum();
    }

    private boolean canPlaceOutput(ItemMachineComponent component, @Nullable String slot, Item item, @Nullable CompoundTag nbt) {
        ItemStack stack = Utils.makeItemStack(item, 1, nbt);
        if (slot != null && !slot.isEmpty() && !component.getId().equals(slot)) {
            return false;
        }
        if (!component.isItemValid(stack)) {
            return false;
        }
        if (component.getItemStack().m_41619_()) {
            return true;
        }
        if (component.getItemStack().m_41720_() != item) {
            return false;
        }
        if (component.getItemStack().m_41613_() >= Math.min(stack.m_41741_(), component.getCapacity())) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)component.getItemStack(), (ItemStack)stack);
    }

    public int getSpaceForDurability(String slot, Item item, @Nullable CompoundTag nbt) {
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.m_128456_() || component.getItemStack().m_41783_() != null && Utils.testNBT(component.getItemStack().m_41783_(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        return this.inputs.stream().filter(component -> component.getItemStack().m_41720_() == item && component.getItemStack().m_41763_() && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).mapToInt(component -> component.getItemStack().m_41773_()).sum();
    }

    public void removeFromInputs(String slot, Item item, int amount, @Nullable CompoundTag nbt) {
        AtomicInteger toRemove = new AtomicInteger(amount);
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.m_128456_() || component.getItemStack().m_41783_() != null && Utils.testNBT(component.getItemStack().m_41783_(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        this.inputs.stream().filter(component -> component.getItemStack().m_41720_() == item && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).forEach(component -> {
            int maxExtract = Math.min(component.getItemStack().m_41613_(), toRemove.get());
            toRemove.addAndGet(-maxExtract);
            component.extract(maxExtract, false, true);
        });
        this.getManager().markDirty();
    }

    public void removeDurability(String slot, Item item, int amount, @Nullable CompoundTag nbt, boolean canBreak) {
        AtomicInteger toRemove = new AtomicInteger(amount);
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.m_128456_() || component.getItemStack().m_41783_() != null && Utils.testNBT(component.getItemStack().m_41783_(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        this.inputs.stream().filter(component -> component.getItemStack().m_41720_() == item && component.getItemStack().m_41763_() && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).forEach(component -> {
            int maxRemove = Math.min(component.getItemStack().m_41776_() - component.getItemStack().m_41773_(), toRemove.get());
            toRemove.addAndGet(-maxRemove);
            ItemStack stack = component.getItemStack();
            if (stack.m_220157_(maxRemove, this.rand, null) && canBreak) {
                stack.m_41774_(1);
                stack.m_41721_(0);
            }
        });
        this.getManager().markDirty();
    }

    public void addToOutputs(String slot, Item item, int amount, @Nullable CompoundTag nbt) {
        AtomicInteger toAdd = new AtomicInteger(amount);
        this.outputs.stream().filter(component -> this.canPlaceOutput((ItemMachineComponent)component, slot, item, nbt)).forEach(component -> {
            int maxInsert = Math.min(component.insert(item, amount, nbt, true, true), toAdd.get());
            toAdd.addAndGet(-maxInsert);
            component.insert(item, maxInsert, nbt, false, true);
        });
        this.getManager().markDirty();
    }

    public void repairItem(String slot, Item item, int amount, @Nullable CompoundTag nbt) {
        AtomicInteger toRepair = new AtomicInteger(amount);
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.m_128456_() || component.getItemStack().m_41783_() != null && Utils.testNBT(component.getItemStack().m_41783_(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        this.inputs.stream().filter(component -> component.getItemStack().m_41720_() == item && component.getItemStack().m_41763_() && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).forEach(component -> {
            int maxRepair = Math.min(component.getItemStack().m_41773_(), toRepair.get());
            toRepair.addAndGet(-maxRepair);
            component.getItemStack().m_41721_(component.getItemStack().m_41773_() - maxRepair);
        });
        this.getManager().markDirty();
    }
}

