/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.craft;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.crafting.RecipeChecker;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CustomCraftRecipe
implements Recipe<Container>,
IMachineRecipe {
    public static final List<RequirementType<?>> FORBIDDEN_REQUIREMENTS = Lists.newArrayList((Object[])new RequirementType[]{(RequirementType)Registration.ENERGY_PER_TICK_REQUIREMENT.get(), (RequirementType)Registration.FLUID_PER_TICK_REQUIREMENT.get(), (RequirementType)Registration.EXPERIENCE_PER_TICK_REQUIREMENT.get()});
    private final ResourceLocation id;
    private final ResourceLocation machine;
    private final ItemStack output;
    private final List<IRequirement<?>> requirements;
    private final List<IRequirement<?>> jeiRequirements;
    private final int priority;
    private final int jeiPriority;
    private final boolean hidden;
    private final Supplier<RecipeChecker<CustomCraftRecipe>> checker = Suppliers.memoize(() -> new RecipeChecker<CustomCraftRecipe>(this));

    public CustomCraftRecipe(ResourceLocation id, ResourceLocation machine, ItemStack output, List<IRequirement<?>> requirements, List<IRequirement<?>> jeiRequirements, int priority, int jeiPriority, boolean hidden) {
        this.id = id;
        this.machine = machine;
        this.output = output;
        this.requirements = this.validateRequirements(requirements);
        this.jeiRequirements = this.validateRequirements(jeiRequirements);
        this.priority = priority;
        this.jeiPriority = jeiPriority;
        this.hidden = hidden;
    }

    @Override
    public ResourceLocation getMachineId() {
        return this.machine;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    private List<IRequirement<?>> validateRequirements(List<IRequirement<?>> requirements) {
        return requirements.stream().filter(requirement -> {
            if (!FORBIDDEN_REQUIREMENTS.contains(requirement.getType())) {
                return true;
            }
            ICustomMachineryAPI.INSTANCE.logger().error("Invalid requirement: {} in craft recipe: {}", (Object)IRequirement.CODEC.encodeStart(JsonOps.INSTANCE, (IRequirement<?>)requirement).result().map(JsonElement::toString).orElse(requirement.getType().toString()), (Object)this.id);
            return false;
        }).toList();
    }

    @Override
    public ResourceLocation getRecipeId() {
        return this.id;
    }

    @Override
    public int getRecipeTime() {
        return 0;
    }

    @Override
    public List<IRequirement<?>> getRequirements() {
        return this.requirements;
    }

    @Override
    public List<IRequirement<?>> getJeiRequirements() {
        return this.jeiRequirements;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getJeiPriority() {
        return this.jeiPriority;
    }

    @Override
    public boolean shouldResetOnError() {
        return false;
    }

    @Override
    public boolean showInJei() {
        return !this.hidden;
    }

    public RecipeChecker<CustomCraftRecipe> checker() {
        return this.checker.get();
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container) {
        return null;
    }

    public boolean m_8004_(int i, int j) {
        return false;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registration.CUSTOM_CRAFT_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)Registration.CUSTOM_CRAFT_RECIPE.get();
    }
}

