/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class CustomMachineRecipeSerializer
implements RecipeSerializer<CustomMachineRecipe> {
    public CustomMachineRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        ICustomMachineryAPI.INSTANCE.logger().info("Parsing recipe json: {}", (Object)recipeId);
        DataResult<Pair<CustomMachineRecipeBuilder, JsonObject>> result = CustomMachineRecipeBuilder.CODEC.decode(JsonOps.INSTANCE, json);
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Successfully read recipe json: {}", (Object)recipeId);
            return ((CustomMachineRecipeBuilder)((Pair)result.result().get()).getFirst()).build(recipeId);
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing recipe json: {}, skipping...\n{}", (Object)recipeId, (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new JsonParseException("Error while parsing Custom Machine Recipe json: " + recipeId + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when parsing Custom Machine Recipe json: " + recipeId + "This can't happen");
    }

    @Nullable
    public CustomMachineRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ICustomMachineryAPI.INSTANCE.logger().info("Receiving recipe: {} from server.", (Object)recipeId);
        DataResult<CustomMachineRecipeBuilder> result = CustomMachineRecipeBuilder.CODEC.read(NbtOps.f_128958_, buffer.m_130261_());
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Sucessfully received recipe: {} from server.", (Object)recipeId);
            return ((CustomMachineRecipeBuilder)result.result().get()).build(recipeId);
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing recipe json: {}, skipping...\n{}", (Object)recipeId, (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new IllegalArgumentException("Error while receiving Custom Machine Recipe from server: " + recipeId + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when receiving Custom Machine Recipe: " + recipeId + "from server. This can't happen");
    }

    public void toNetwork(FriendlyByteBuf buffer, CustomMachineRecipe recipe) {
        ICustomMachineryAPI.INSTANCE.logger().info("Sending recipe: {} to clients", (Object)recipe.m_6423_());
        DataResult result = CustomMachineRecipeBuilder.CODEC.encodeStart(NbtOps.f_128958_, new CustomMachineRecipeBuilder(recipe));
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Sucessfully send recipe: {} to clients.", (Object)recipe.m_6423_());
            buffer.m_130079_((CompoundTag)result.result().get());
            return;
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while sending recipe: {} to clients.%n{}", (Object)recipe.m_6423_(), (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new IllegalArgumentException("Error while sending Custom Machine Recipe to clients: " + recipe.m_6423_() + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when sending Custom Machine Recipe: " + recipe.m_6423_() + "to clients. This can't happen");
    }
}

