/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BoxCreatorItem
extends Item {
    private static final String FIRST_BLOCK_KEY = "firstBlock";
    private static final String SECOND_BLOCK_KEY = "secondBlock";

    public BoxCreatorItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public static BlockPos getSelectedBlock(boolean first, ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("custommachinery");
        if (nbt != null && nbt.m_128454_(first ? FIRST_BLOCK_KEY : SECOND_BLOCK_KEY) != 0L) {
            return BlockPos.m_122022_((long)nbt.m_128454_(first ? FIRST_BLOCK_KEY : SECOND_BLOCK_KEY));
        }
        return null;
    }

    public static void setSelectedBlock(boolean first, ItemStack stack, BlockPos pos) {
        long packed = pos.m_121878_();
        stack.m_41698_("custommachinery").m_128356_(first ? FIRST_BLOCK_KEY : SECOND_BLOCK_KEY, packed);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        BlockPos block1 = BoxCreatorItem.getSelectedBlock(true, stack);
        if (block1 != null) {
            tooltip.add((Component)Component.m_237110_((String)"custommachinery.box_creator.first_block", (Object[])new Object[]{block1.m_123344_()}).m_130940_(ChatFormatting.BLUE));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"custommachinery.box_creator.select_first_block").m_130940_(ChatFormatting.BLUE));
        }
        BlockPos block2 = BoxCreatorItem.getSelectedBlock(false, stack);
        if (block2 != null) {
            tooltip.add((Component)Component.m_237110_((String)"custommachinery.box_creator.second_block", (Object[])new Object[]{block2.m_123344_()}).m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"custommachinery.box_creator.select_second_block").m_130940_(ChatFormatting.RED));
        }
        if (block1 != null && block2 != null) {
            tooltip.add((Component)Component.m_237115_((String)"custommachinery.box_creator.select_machine").m_130940_(ChatFormatting.GREEN));
        }
        tooltip.add((Component)Component.m_237115_((String)"custommachinery.box_creator.reset").m_130940_(ChatFormatting.GOLD));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        BlockPos block1 = BoxCreatorItem.getSelectedBlock(true, stack);
        BlockPos block2 = BoxCreatorItem.getSelectedBlock(false, stack);
        if (!(context.m_43725_().m_8055_(pos).m_60734_() instanceof CustomMachineBlock)) {
            BoxCreatorItem.setSelectedBlock(false, stack, pos);
            return InteractionResult.SUCCESS;
        }
        if (block1 != null && block2 != null && !context.m_43725_().m_5776_()) {
            AABB aabb = new AABB(block1, block2);
            aabb = aabb.m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
            Direction direction = (Direction)context.m_43725_().m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61374_);
            aabb = Utils.rotateBox(aabb, direction);
            String boxString = "[" + (int)aabb.f_82288_ + ", " + (int)aabb.f_82289_ + ", " + (int)aabb.f_82290_ + ", " + (int)aabb.f_82291_ + ", " + (int)aabb.f_82292_ + ", " + (int)aabb.f_82293_ + "]";
            MutableComponent boxText = Component.m_237113_((String)boxString).m_130948_(Style.f_131099_.m_131157_(ChatFormatting.AQUA).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"custommachinery.box_creator.copy"))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, boxString)));
            MutableComponent message = Component.m_237110_((String)"custommachinery.box_creator.create_box", (Object[])new Object[]{boxText});
            context.m_43723_().m_213846_((Component)message);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && stack.m_41720_() == this) {
            stack.m_41749_("custommachinery");
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }
}

