/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class CustomMachineItem
extends BlockItem {
    public static final String MACHINE_TAG_KEY = "machine";
    @Nullable
    private final ResourceLocation machineID;

    public CustomMachineItem(Block block, Item.Properties properties, @Nullable ResourceLocation machineID) {
        super(block, properties);
        this.machineID = machineID;
    }

    public static Optional<CustomMachine> getMachine(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CustomMachineItem) {
            CustomMachineItem customMachineItem = (CustomMachineItem)item;
            if (customMachineItem.machineID != null) {
                return Optional.ofNullable(CustomMachinery.MACHINES.get(customMachineItem.machineID));
            }
        }
        if (stack.m_41720_() == Registration.CUSTOM_MACHINE_ITEM.get() && stack.m_41783_() != null && stack.m_41783_().m_128425_(MACHINE_TAG_KEY, 8) && Utils.isResourceNameValid(stack.m_41783_().m_128461_(MACHINE_TAG_KEY))) {
            ResourceLocation machineID = new ResourceLocation(stack.m_41783_().m_128461_(MACHINE_TAG_KEY));
            if (machineID.equals((Object)CustomMachine.DUMMY.getId())) {
                return Optional.of(CustomMachine.DUMMY);
            }
            return Optional.ofNullable(CustomMachinery.MACHINES.get(machineID));
        }
        return Optional.empty();
    }

    public static ItemStack makeMachineItem(ResourceLocation machineID) {
        if (CustomMachinery.CUSTOM_BLOCK_MACHINES.containsKey((Object)machineID)) {
            return ((CustomMachineBlock)((Object)CustomMachinery.CUSTOM_BLOCK_MACHINES.get((Object)machineID))).m_5456_().m_7968_();
        }
        ItemStack stack = ((CustomMachineItem)((Object)Registration.CUSTOM_MACHINE_ITEM.get())).m_7968_();
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(MACHINE_TAG_KEY, machineID.toString());
        stack.m_41751_(nbt);
        return stack;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (group == this.f_41377_ || group == CreativeModeTab.f_40754_) {
            if (this.machineID != null) {
                items.add((Object)this.m_7968_());
            } else {
                CustomMachinery.MACHINES.keySet().stream().filter(id -> !CustomMachinery.CUSTOM_BLOCK_MACHINES.containsKey(id)).forEach(id -> items.add((Object)CustomMachineItem.makeMachineItem(id)));
            }
        }
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128425_(MACHINE_TAG_KEY, 8)) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_(MACHINE_TAG_KEY, CustomMachine.DUMMY.getId().toString());
            stack.m_41751_(nbt);
        }
        super.m_7836_(stack, worldIn, playerIn);
    }

    public Component m_7626_(ItemStack stack) {
        return CustomMachineItem.getMachine(stack).map(CustomMachine::getName).orElse(super.m_7626_(stack));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        CustomMachineItem.getMachine(stack).map(CustomMachine::getTooltips).ifPresent(tooltip::addAll);
    }

    public InteractionResult m_40576_(BlockPlaceContext blockPlaceContext) {
        Block block;
        if (!blockPlaceContext.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockPlaceContext2 = this.m_7732_(blockPlaceContext);
        if (blockPlaceContext2 == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = this.m_5965_(blockPlaceContext2);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.m_7429_(blockPlaceContext2, blockState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext2.m_8083_();
        Level level = blockPlaceContext2.m_43725_();
        Player player = blockPlaceContext2.m_43723_();
        ItemStack itemStack = blockPlaceContext2.m_43722_();
        BlockState blockState2 = level.m_8055_(blockPos);
        if (blockState2.m_60713_(blockState.m_60734_())) {
            this.m_7274_(blockPos, level, player, itemStack, blockState2);
            blockState2.m_60734_().m_6402_(level, blockPos, blockState2, (LivingEntity)player, itemStack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, blockPos, itemStack);
            }
        }
        if ((block = blockState2.m_60734_()) instanceof CustomMachineBlock) {
            CustomMachineBlock machineBlock = (CustomMachineBlock)block;
            SoundType soundType = machineBlock.getSoundType(blockState, (LevelReader)level, blockPos, (Entity)player);
            level.m_5594_(player, blockPos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            level.m_142346_((Entity)player, GameEvent.f_157797_, blockPos);
        }
        if (player == null || !player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

