/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import com.mojang.serialization.DynamicOps;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.crafting.ComponentNotFoundException;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.IMachineAppearance;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.DummyComponentManager;
import fr.frinn.custommachinery.common.component.MachineComponentManager;
import fr.frinn.custommachinery.common.crafting.DummyProcessor;
import fr.frinn.custommachinery.common.crafting.UpgradeManager;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.network.SRefreshCustomMachineTilePacket;
import fr.frinn.custommachinery.common.network.SUpdateMachineAppearancePacket;
import fr.frinn.custommachinery.common.network.SUpdateMachineGuiElementsPacket;
import fr.frinn.custommachinery.common.network.SUpdateMachineStatusPacket;
import fr.frinn.custommachinery.common.network.syncable.StringSyncable;
import fr.frinn.custommachinery.common.util.MachineList;
import fr.frinn.custommachinery.common.util.SoundManager;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class CustomMachineTile
extends MachineTile
implements ISyncableStuff {
    public static final ResourceLocation DUMMY = new ResourceLocation("custommachinery", "dummy");
    private ResourceLocation id = DUMMY;
    private boolean paused = false;
    private IProcessor processor = new DummyProcessor(this);
    private MachineComponentManager componentManager = new DummyComponentManager(this);
    private final UpgradeManager upgradeManager = new UpgradeManager(this);
    private SoundManager soundManager;
    private MachineStatus status = MachineStatus.IDLE;
    private Component errorMessage = Component.m_237119_();
    @Nullable
    private MachineAppearance customAppearance = null;
    @Nullable
    private List<IGuiElement> customGuiElements = null;
    @Nullable
    private Component ownerName;
    @Nullable
    private UUID ownerID;
    private List<WeakReference<ServerPlayer>> players = new ArrayList<WeakReference<ServerPlayer>>();
    private boolean unloaded = false;

    public CustomMachineTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.CUSTOM_MACHINE_TILE.get(), pos, state);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
        this.processor = this.getMachine().getProcessorTemplate().build(this);
        this.componentManager = new MachineComponentManager(this.getMachine().getComponentTemplates(), this);
        this.componentManager.getComponents().values().forEach(IMachineComponent::init);
    }

    @Override
    public CustomMachine getMachine() {
        CustomMachine machine = CustomMachinery.MACHINES.get(this.getId());
        if (machine != null) {
            return machine;
        }
        return CustomMachine.DUMMY;
    }

    @Override
    public MachineStatus getStatus() {
        if (this.isPaused()) {
            return MachineStatus.PAUSED;
        }
        return this.status;
    }

    @Override
    public Component getMessage() {
        return this.errorMessage;
    }

    @Override
    public void setStatus(MachineStatus status, Component message) {
        if (this.status != status) {
            this.componentManager.getComponents().values().forEach(component -> component.onStatusChanged(this.status, status, message));
            this.status = status;
            this.errorMessage = message;
            this.m_6596_();
            if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
                BlockPos pos = this.m_58899_();
                new SUpdateMachineStatusPacket(pos, this.status).sendToChunkListeners(this.m_58904_().m_46745_(pos));
            }
        }
    }

    @Override
    public void refreshMachine(@Nullable ResourceLocation id) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        CompoundTag craftingManagerNBT = this.processor.serialize();
        CompoundTag componentManagerNBT = this.componentManager.serializeNBT();
        if (id == null) {
            id = this.getId();
        }
        this.id = id;
        this.processor = this.getMachine().getProcessorTemplate().build(this);
        this.componentManager = new MachineComponentManager(this.getMachine().getComponentTemplates(), this);
        this.processor.deserialize(craftingManagerNBT);
        this.componentManager.deserializeNBT(componentManagerNBT);
        this.componentManager.getComponents().values().forEach(IMachineComponent::init);
        new SRefreshCustomMachineTilePacket(this.f_58858_, id).sendToChunkListeners(this.f_58857_.m_46745_(this.f_58858_));
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void resetProcess() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        this.processor.reset();
    }

    @Override
    public MachineComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    @Override
    public IProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public MachineAppearance getAppearance() {
        if (this.customAppearance != null) {
            return this.customAppearance;
        }
        return this.getMachine().getAppearance(this.getStatus());
    }

    @Override
    public void setCustomAppearance(@Nullable IMachineAppearance customAppearance) {
        if (this.customAppearance == customAppearance) {
            return;
        }
        this.customAppearance = (MachineAppearance)customAppearance;
        if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            BlockPos pos = this.m_58899_();
            new SUpdateMachineAppearancePacket(pos, this.customAppearance).sendToChunkListeners(this.m_58904_().m_46745_(pos));
        }
    }

    @Override
    public List<IGuiElement> getGuiElements() {
        if (this.customGuiElements != null && !this.customGuiElements.isEmpty()) {
            return this.customGuiElements;
        }
        return this.getMachine().getGuiElements();
    }

    @Override
    public void setCustomGuiElements(@Nullable List<IGuiElement> customGuiElements) {
        if (this.customGuiElements == customGuiElements || this.customGuiElements != null && customGuiElements != null && !customGuiElements.isEmpty() && new HashSet<IGuiElement>(this.customGuiElements).containsAll(customGuiElements)) {
            return;
        }
        this.customGuiElements = customGuiElements;
        if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            BlockPos pos = this.m_58899_();
            new SUpdateMachineGuiElementsPacket(pos, this.customGuiElements).sendToChunkListeners(this.m_58904_().m_46745_(pos));
            Iterator<WeakReference<ServerPlayer>> iterator = this.players.iterator();
            while (iterator.hasNext()) {
                CustomMachineContainer container;
                AbstractContainerMenu abstractContainerMenu;
                ServerPlayer player = (ServerPlayer)iterator.next().get();
                if (player == null || !((abstractContainerMenu = player.f_36096_) instanceof CustomMachineContainer) || (container = (CustomMachineContainer)abstractContainerMenu).getTile() != this) {
                    iterator.remove();
                    continue;
                }
                container.init();
            }
        }
    }

    @Override
    public void setOwner(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        this.ownerName = entity.m_7755_();
        this.ownerID = entity.m_20148_();
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return this.ownerID;
    }

    @Override
    @Nullable
    public Component getOwnerName() {
        return this.ownerName;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CustomMachineTile tile) {
        if (tile.componentManager == null || tile.processor == null) {
            return;
        }
        level.m_46473_().m_6180_("Component tick");
        tile.componentManager.serverTick();
        level.m_46473_().m_7238_();
        if (tile.isPaused()) {
            return;
        }
        level.m_46473_().m_6180_("Crafting Manager tick");
        try {
            tile.processor.tick();
        }
        catch (ComponentNotFoundException e) {
            CustomMachinery.LOGGER.error(e.getMessage());
            tile.setPaused(true);
        }
        level.m_46473_().m_7238_();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CustomMachineTile tile) {
        if (tile.componentManager == null || tile.processor == null) {
            return;
        }
        tile.componentManager.clientTick();
        if (tile.soundManager == null) {
            tile.soundManager = new SoundManager(pos);
        }
        if (!tile.getAppearance().getAmbientSound().m_11660_().equals((Object)tile.soundManager.getSoundID())) {
            if (tile.getAppearance().getAmbientSound() == ((MachineAppearanceProperty)Registration.AMBIENT_SOUND_PROPERTY.get()).getDefaultValue()) {
                tile.soundManager.setSound(null);
            } else {
                tile.soundManager.setSound(tile.getAppearance().getAmbientSound());
            }
        }
        if (!tile.soundManager.isPlaying()) {
            tile.soundManager.play();
        }
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        MachineList.addMachine(this);
        this.componentManager.getComponents().values().forEach(IMachineComponent::init);
    }

    public void m_7651_() {
        if (this.f_58857_ != null && this.f_58857_.m_5776_() && this.soundManager != null) {
            this.soundManager.stop();
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.componentManager.getComponents().values().forEach(IMachineComponent::onRemoved);
        }
        super.m_7651_();
    }

    public void unload() {
        this.unloaded = true;
    }

    @Override
    public boolean isUnloaded() {
        return this.unloaded;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128359_("machineID", this.id.toString());
        nbt.m_128365_("craftingManager", (Tag)this.processor.serialize());
        nbt.m_128365_("componentManager", (Tag)this.componentManager.serializeNBT());
        nbt.m_128359_("status", this.status.toString());
        nbt.m_128359_("message", TextComponentUtils.toJsonString(this.errorMessage));
        if (this.ownerID != null) {
            nbt.m_128359_("ownerID", this.ownerID.toString());
        }
        if (this.ownerName != null) {
            nbt.m_128359_("ownerName", TextComponentUtils.toJsonString(this.ownerName));
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("machineID", 8) && this.getMachine() == CustomMachine.DUMMY) {
            this.setId(new ResourceLocation(nbt.m_128461_("machineID")));
        }
        if (nbt.m_128425_("craftingManager", 10)) {
            this.processor.deserialize(nbt.m_128469_("craftingManager"));
        }
        if (nbt.m_128425_("componentManager", 10)) {
            this.componentManager.deserializeNBT(nbt.m_128469_("componentManager"));
        }
        if (nbt.m_128425_("status", 8)) {
            this.setStatus(MachineStatus.value(nbt.m_128461_("status")));
        }
        if (nbt.m_128425_("message", 8)) {
            this.errorMessage = TextComponentUtils.fromJsonString(nbt.m_128461_("message"));
        }
        if (nbt.m_128425_("ownerID", 8)) {
            this.ownerID = UUID.fromString(nbt.m_128461_("ownerID"));
        }
        if (nbt.m_128425_("ownerName", 8)) {
            this.ownerName = TextComponentUtils.fromJsonString(nbt.m_128461_("ownerName"));
        }
        if (nbt.m_128425_("appearance", 10)) {
            this.customAppearance = MachineAppearance.CODEC.read((DynamicOps)NbtOps.f_128958_, nbt.m_128423_("appearance")).result().map(MachineAppearance::new).orElse(null);
        }
        if (nbt.m_128425_("gui", 9)) {
            this.customGuiElements = IGuiElement.CODEC.listOf().read(NbtOps.f_128958_, nbt.m_128437_("gui", 10)).result().orElse(Collections.emptyList());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128359_("machineID", this.getId().toString());
        nbt.m_128359_("status", this.status.toString());
        nbt.m_128359_("message", TextComponentUtils.toJsonString(this.errorMessage));
        if (this.ownerID != null) {
            nbt.m_128359_("ownerID", this.ownerID.toString());
        }
        if (this.ownerName != null) {
            nbt.m_128359_("ownerName", TextComponentUtils.toJsonString(this.ownerName));
        }
        if (this.customAppearance != null) {
            MachineAppearance.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.customAppearance.getProperties()).result().ifPresent(appearance -> nbt.m_128365_("appearance", appearance));
        }
        if (this.customGuiElements != null && !this.customGuiElements.isEmpty()) {
            IGuiElement.CODEC.listOf().encodeStart(NbtOps.f_128958_, this.customGuiElements).result().ifPresent(elements -> nbt.m_128365_("gui", elements));
        }
        return nbt;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        IProcessor iProcessor = this.processor;
        if (iProcessor instanceof ISyncableStuff) {
            ISyncableStuff syncableProcessor = (ISyncableStuff)((Object)iProcessor);
            syncableProcessor.getStuffToSync(container);
        }
        this.componentManager.getStuffToSync(container);
        container.accept(StringSyncable.create(() -> this.status.toString(), status -> {
            this.status = MachineStatus.value(status);
        }));
        container.accept(StringSyncable.create(() -> Component.Serializer.m_130703_((Component)this.errorMessage), errorMessage -> {
            this.errorMessage = Component.Serializer.m_130701_((String)errorMessage);
        }));
    }

    public void startInteracting(ServerPlayer player) {
        if (this.players.stream().noneMatch(ref -> ref.get() == player)) {
            this.players.add(new WeakReference<ServerPlayer>(player));
        }
    }

    public void stopInteracting(ServerPlayer player) {
        Iterator<WeakReference<ServerPlayer>> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            ServerPlayer ref = (ServerPlayer)iterator.next().get();
            if (ref != null && ref != player && ref.f_36096_ instanceof CustomMachineContainer) continue;
            iterator.remove();
        }
    }
}

