/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.google.common.collect.ImmutableList;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.api.upgrade.IRecipeModifier;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.integration.crafttweaker.RequirementTypeCTBrackets;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.RecipeModifier;
import fr.frinn.custommachinery.common.upgrade.modifier.AdditionRecipeModifier;
import fr.frinn.custommachinery.common.upgrade.modifier.ExponentialRecipeModifier;
import fr.frinn.custommachinery.common.upgrade.modifier.MultiplicationRecipeModifier;
import fr.frinn.custommachinery.common.upgrade.modifier.SpeedRecipeModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.CMUpgradeBuilder")
public class CustomMachineUpgradeCTBuilder {
    private final Item item;
    private List<Component> tooltips;
    private final List<ResourceLocation> machines;
    private final List<RecipeModifier> modifiers;
    private final int maxAmount;

    public CustomMachineUpgradeCTBuilder(Item item, int maxAmount) {
        this.item = item;
        this.tooltips = Collections.singletonList(Component.m_237115_((String)"custommachinery.upgrade.tooltip").m_130940_(ChatFormatting.AQUA));
        this.maxAmount = maxAmount;
        this.machines = new ArrayList<ResourceLocation>();
        this.modifiers = new ArrayList<RecipeModifier>();
    }

    @ZenCodeType.Method
    public static CustomMachineUpgradeCTBuilder create(Item item, @ZenCodeType.OptionalInt(value=64) int maxAmount) {
        return new CustomMachineUpgradeCTBuilder(item, maxAmount);
    }

    @ZenCodeType.Method
    public void build() {
        if (this.machines.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 machine for machine upgrade item: " + Registry.f_122827_.m_7981_((Object)this.item));
        }
        if (this.modifiers.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 recipe modifier for machine upgrade item: " + Registry.f_122827_.m_7981_((Object)this.item));
        }
        MachineUpgrade upgrade = new MachineUpgrade(this.item, this.machines, this.modifiers, this.tooltips, this.maxAmount);
        CraftTweakerAPI.apply((IAction)new AddMachineUpgradeAction(upgrade));
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder machine(String ... string) {
        for (String s : string) {
            ResourceLocation machine;
            try {
                machine = new ResourceLocation(s);
            }
            catch (ResourceLocationException e) {
                throw new IllegalArgumentException("Invalid Machine ID: " + s + "\n" + e.getMessage());
            }
            this.machines.add(machine);
        }
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder tooltip(String ... strings) {
        ImmutableList.Builder tooltips = ImmutableList.builder();
        for (String tooltip : strings) {
            try {
                MutableComponent component = Component.Serializer.m_130701_((String)tooltip);
                if (component == null) {
                    throw new IllegalArgumentException("");
                }
                tooltips.add((Object)component);
            }
            catch (Exception e) {
                tooltips.add((Object)Component.m_237115_((String)tooltip));
            }
        }
        this.tooltips = tooltips.build();
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder tooltip(Component ... components) {
        this.tooltips = ImmutableList.copyOf((Object[])components);
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder modifier(CTRecipeModifierBuilder builder) {
        this.modifiers.add(builder.build());
        return this;
    }

    public static class AddMachineUpgradeAction
    implements IRuntimeAction {
        private final MachineUpgrade upgrade;

        public AddMachineUpgradeAction(MachineUpgrade upgrade) {
            this.upgrade = upgrade;
        }

        public void apply() {
            CustomMachinery.UPGRADES.addUpgrade(this.upgrade);
        }

        public String describe() {
            return "Add a custom machine upgrade for item: " + Registry.f_122827_.m_7981_((Object)this.upgrade.getItem());
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.custommachinery.CMRecipeModifierBuilder")
    public static class CTRecipeModifierBuilder {
        private final RequirementType<?> requirement;
        private final RequirementIOMode mode;
        private final IRecipeModifier.OPERATION operation;
        private final double modifier;
        private String target = "";
        private double chance = 1.0;
        private double max = Double.POSITIVE_INFINITY;
        private double min = Double.NEGATIVE_INFINITY;
        private Component tooltip = null;

        private CTRecipeModifierBuilder(RequirementType<?> type, RequirementIOMode mode, IRecipeModifier.OPERATION operation, double modifier) {
            this.requirement = type;
            this.mode = mode;
            this.operation = operation;
            this.modifier = modifier;
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder addInput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.ADDITION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder mulInput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.MULTIPLICATION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder expInput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.EXPONENTIAL, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder addOutput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.ADDITION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder mulOutput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.MULTIPLICATION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder expOutput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.EXPONENTIAL, modifier);
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder target(String target) {
            this.target = target;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder chance(double chance) {
            this.chance = chance;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder max(double max) {
            this.max = max;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder min(double min) {
            this.min = min;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder tooltip(String tooltip) {
            try {
                this.tooltip = Component.Serializer.m_130701_((String)tooltip);
            }
            catch (Exception e) {
                this.tooltip = Component.m_237115_((String)tooltip);
            }
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder tooltip(Component tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        private RecipeModifier build() {
            if (this.requirement == Registration.SPEED_REQUIREMENT.get()) {
                return new SpeedRecipeModifier(this.operation, this.modifier, this.chance, this.max, this.min, this.tooltip);
            }
            return switch (this.operation) {
                default -> throw new IncompatibleClassChangeError();
                case IRecipeModifier.OPERATION.ADDITION -> new AdditionRecipeModifier(this.requirement, this.mode, this.modifier, this.target, this.chance, this.max, this.min, this.tooltip);
                case IRecipeModifier.OPERATION.MULTIPLICATION -> new MultiplicationRecipeModifier(this.requirement, this.mode, this.modifier, this.target, this.chance, this.max, this.min, this.tooltip);
                case IRecipeModifier.OPERATION.EXPONENTIAL -> new ExponentialRecipeModifier(this.requirement, this.mode, this.modifier, this.target, this.chance, this.max, this.min, this.tooltip);
            };
        }
    }
}

