/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.BracketDumper;
import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.BracketValidator;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.Collection;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.RequirementTypeBracket")
public class RequirementTypeCTBrackets {
    @ZenCodeType.Method
    @BracketResolver(value="requirementtype")
    public static CTRequirementType parseBracket(String bracket) {
        return new CTRequirementType((RequirementType)Registration.REQUIREMENT_TYPE_REGISTRY.get(new ResourceLocation(bracket)));
    }

    @ZenCodeType.Method
    @BracketValidator(value="requirementtype")
    public static boolean validateBracket(String bracket) {
        ResourceLocation requirementTypeLocation;
        try {
            requirementTypeLocation = new ResourceLocation(bracket);
        }
        catch (ResourceLocationException e) {
            throw new IllegalArgumentException("Invalid Requirement Type bracket: " + bracket, e);
        }
        if (!Registration.REQUIREMENT_TYPE_REGISTRY.contains(requirementTypeLocation)) {
            throw new IllegalArgumentException("Unknown Requirement type: " + requirementTypeLocation);
        }
        return true;
    }

    @ZenCodeType.Method
    @BracketDumper(value="requirementtype")
    public static Collection<String> dumpBrackets() {
        return Registration.REQUIREMENT_TYPE_REGISTRY.getIds().stream().map(type -> "<requirementtype:" + type + ">").toList();
    }

    public static class CTRequirementType
    implements CommandStringDisplayable {
        private final RequirementType<?> type;

        public CTRequirementType(RequirementType<?> type) {
            this.type = type;
        }

        public RequirementType<?> getType() {
            return this.type;
        }

        public String getCommandString() {
            return "<requirementtype:" + Registration.REQUIREMENT_TYPE_REGISTRY.getId(this.type) + ">";
        }
    }
}

