/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.function;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import dev.architectury.fluid.FluidStack;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.component.ChunkloadMachineComponent;
import fr.frinn.custommachinery.common.component.DataMachineComponent;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.TaskDelayer;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.Machine")
public class MachineCT {
    private final CustomMachineTile internal;
    private final MapData data;

    protected MachineCT(CustomMachineTile internal) {
        this.internal = internal;
        this.data = new MapData(((DataMachineComponent)this.internal.getComponentManager().getComponent((MachineComponentType)Registration.DATA_MACHINE_COMPONENT.get()).orElseThrow()).getData());
    }

    @ZenCodeType.Getter(value="id")
    @ZenCodeType.Method
    public String getId() {
        return this.internal.getId().toString();
    }

    @ZenCodeType.Setter(value="id")
    @ZenCodeType.Method
    public void setId(String id) {
        ResourceLocation loc = ResourceLocation.m_135820_((String)id);
        if (loc == null) {
            throw new IllegalArgumentException("Invalid machine ID: " + id);
        }
        TaskDelayer.enqueue(0, () -> {
            this.internal.resetProcess();
            this.internal.refreshMachine(loc);
        });
    }

    @ZenCodeType.Getter(value="data")
    @ZenCodeType.Method
    public MapData getData() {
        return this.data;
    }

    @ZenCodeType.Getter(value="paused")
    @ZenCodeType.Method
    public boolean getPaused() {
        return this.internal.isPaused();
    }

    @ZenCodeType.Setter(value="paused")
    @ZenCodeType.Method
    public void setPaused(boolean paused) {
        this.internal.setPaused(paused);
    }

    @ZenCodeType.Getter(value="ownerName")
    @ZenCodeType.Method
    @Nullable
    public Component getOwnerName() {
        return this.internal.getOwnerName();
    }

    @ZenCodeType.Getter(value="ownerId")
    @ZenCodeType.Method
    @Nullable
    public UUID getOwnerId() {
        return this.internal.getOwnerId();
    }

    @ZenCodeType.Method
    public boolean isOwner(LivingEntity entity) {
        return this.internal.isOwner(entity);
    }

    @ZenCodeType.Getter(value="owner")
    @ZenCodeType.Method
    @Nullable
    public LivingEntity getOwner() {
        return this.internal.getOwner();
    }

    @ZenCodeType.Setter(value="owner")
    @ZenCodeType.Method
    public void setOwner(LivingEntity entity) {
        this.internal.setOwner(entity);
    }

    @ZenCodeType.Getter(value="energyStored")
    @ZenCodeType.Method
    public long getEnergyStored() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)Registration.ENERGY_MACHINE_COMPONENT.get()).map(EnergyMachineComponent::getEnergy).orElse(0L);
    }

    @ZenCodeType.Setter
    @ZenCodeType.Method
    public void setEnergyStored(long energy) {
        this.internal.getComponentManager().getComponent((MachineComponentType)Registration.ENERGY_MACHINE_COMPONENT.get()).ifPresent(component -> component.setEnergy(energy));
    }

    @ZenCodeType.Getter(value="energyCapacity")
    @ZenCodeType.Method
    public long getEnergyCapacity() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)Registration.ENERGY_MACHINE_COMPONENT.get()).map(EnergyMachineComponent::getCapacity).orElse(0L);
    }

    @ZenCodeType.Method
    public int addEnergy(int toAdd, boolean simulate) {
        return this.internal.getComponentManager().getComponent((MachineComponentType)Registration.ENERGY_MACHINE_COMPONENT.get()).map(component -> component.receiveRecipeEnergy(toAdd, simulate)).orElse(0);
    }

    @ZenCodeType.Method
    public int removeEnergy(int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponent((MachineComponentType)Registration.ENERGY_MACHINE_COMPONENT.get()).map(component -> component.extractRecipeEnergy(toRemove, simulate)).orElse(0);
    }

    @ZenCodeType.Method
    public FluidStack getFluidStored(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(FluidMachineComponent::getFluidStack).orElse(FluidStack.empty());
    }

    @ZenCodeType.Method
    public void setFluidStored(String tank, Fluid fluid, long amount, @ZenCodeType.Optional IData data) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(x -> x.setFluidStack(FluidStack.create((Fluid)fluid, (long)amount, data == null ? null : (CompoundTag)data.getInternal())));
    }

    @ZenCodeType.Method
    public long getFluidCapacity(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(FluidMachineComponent::getCapacity).orElse(0L);
    }

    @ZenCodeType.Method
    public long addFluid(Fluid fluid, long amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).map(handler -> (FluidComponentHandler)handler).map(handler -> handler.fill(FluidStack.create((Fluid)fluid, (long)amount), simulate)).orElse(amount);
    }

    @ZenCodeType.Method
    public long addFluidToTank(String tank, Fluid fluid, long amount, boolean simulate, @ZenCodeType.Optional IData data) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> component.insert(fluid, amount, data == null ? null : (CompoundTag)data.getInternal(), simulate)).orElse(amount);
    }

    @ZenCodeType.Method
    public FluidStack removeFluid(Fluid fluid, int amount, boolean simulate, @ZenCodeType.Optional IData data) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).map(handler -> (FluidComponentHandler)handler).map(handler -> handler.drain(FluidStack.create((Fluid)fluid, (long)amount, data == null ? null : (CompoundTag)data.getInternal()), simulate)).orElse(FluidStack.empty());
    }

    @ZenCodeType.Method
    public FluidStack removeFluidFromTank(String tank, int amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> component.extract(amount, simulate)).orElse(FluidStack.empty());
    }

    @ZenCodeType.Method
    public IItemStack getItemStored(String slot) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(component -> Services.PLATFORM.createItemStack(component.getItemStack())).orElse(Services.PLATFORM.getEmptyItemStack());
    }

    @ZenCodeType.Method
    public void setItemStored(String slot, IItemStack stackCT) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setItemStack(stackCT.getInternal()));
    }

    @ZenCodeType.Method
    public int getItemCapacity(String slot) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(ItemMachineComponent::getCapacity).orElse(0);
    }

    @ZenCodeType.Method
    public IItemStack addItemToSlot(String slot, IItemStack stackCT, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(component -> {
            int inserted = component.insert(stackCT.getDefinition(), stackCT.getAmount(), stackCT.getInternal().m_41783_(), simulate, true);
            return Services.PLATFORM.createItemStack(Utils.makeItemStack(stackCT.getDefinition(), stackCT.getAmount() - inserted, stackCT.getInternal().m_41783_()));
        }).orElse(stackCT);
    }

    @ZenCodeType.Method
    public IItemStack removeItemFromSlot(String slot, int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(component -> Services.PLATFORM.createItemStack(component.extract(toRemove, simulate, true))).orElse(Services.PLATFORM.getEmptyItemStack());
    }

    @ZenCodeType.Method
    public void lockSlot(String slot) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setLocked(true));
    }

    @ZenCodeType.Method
    public void unlockSlot(String slot) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setLocked(false));
    }

    @ZenCodeType.Method
    public boolean isSlotLocked(String slot) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(ItemMachineComponent::isLocked).orElseThrow(() -> new IllegalArgumentException("Invalid slot id: " + slot));
    }

    @ZenCodeType.Method
    public void enableChunkload(int radius) {
        this.internal.getComponentManager().getComponent((MachineComponentType)Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).ifPresent(component -> component.setActive((ServerLevel)this.internal.m_58904_(), radius));
    }

    @ZenCodeType.Method
    public void disableChunkload() {
        this.internal.getComponentManager().getComponent((MachineComponentType)Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).ifPresent(component -> component.setInactive((ServerLevel)this.internal.m_58904_()));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="chunkloadEnabled")
    public boolean isChunkloadEnabled() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).map(ChunkloadMachineComponent::isActive).orElse(false);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="chunkloadRadius")
    public int getChunkloadRadius() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).map(ChunkloadMachineComponent::getRadius).orElse(0);
    }
}

