/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.requirement.BlockRequirement;
import fr.frinn.custommachinery.common.util.ComparatorMode;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Block")
public interface BlockRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T requireBlock(String[] filter, boolean whitelist, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount, @ZenCodeType.OptionalString(value=">=") String comparator) {
        return this.withBlockRequirement(RequirementIOMode.INPUT, BlockRequirement.ACTION.CHECK, "", startX, startY, startZ, endX, endY, endZ, amount, comparator, filter, whitelist);
    }

    @ZenCodeType.Method
    default public T placeBlockOnStart(String block, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withBlockRequirement(RequirementIOMode.INPUT, BlockRequirement.ACTION.PLACE, block, startX, startY, startZ, endX, endY, endZ, amount, "==", new String[0], false);
    }

    @ZenCodeType.Method
    default public T placeBlockOnEnd(String block, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withBlockRequirement(RequirementIOMode.OUTPUT, BlockRequirement.ACTION.PLACE, block, startX, startY, startZ, endX, endY, endZ, amount, "==", new String[0], false);
    }

    @ZenCodeType.Method
    default public T breakAndPlaceBlockOnStart(String block, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount, @ZenCodeType.Optional String[] filter, @ZenCodeType.OptionalBoolean boolean whitelist) {
        return this.withBlockRequirement(RequirementIOMode.INPUT, BlockRequirement.ACTION.REPLACE_BREAK, block, startX, startY, startZ, endX, endY, endZ, amount, "==", filter, whitelist);
    }

    @ZenCodeType.Method
    default public T breakAndPlaceBlockOnEnd(String block, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount, @ZenCodeType.Optional String[] filter, @ZenCodeType.OptionalBoolean boolean whitelist) {
        return this.withBlockRequirement(RequirementIOMode.OUTPUT, BlockRequirement.ACTION.REPLACE_BREAK, block, startX, startY, startZ, endX, endY, endZ, amount, "==", filter, whitelist);
    }

    @ZenCodeType.Method
    default public T destroyAndPlaceBlockOnStart(String block, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount, @ZenCodeType.Optional String[] filter, @ZenCodeType.OptionalBoolean boolean whitelist) {
        return this.withBlockRequirement(RequirementIOMode.INPUT, BlockRequirement.ACTION.REPLACE_DESTROY, block, startX, startY, startZ, endX, endY, endZ, amount, "==", filter, whitelist);
    }

    @ZenCodeType.Method
    default public T destroyAndPlaceBlockOnEnd(String block, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount, @ZenCodeType.Optional String[] filter, @ZenCodeType.OptionalBoolean boolean whitelist) {
        return this.withBlockRequirement(RequirementIOMode.OUTPUT, BlockRequirement.ACTION.REPLACE_DESTROY, block, startX, startY, startZ, endX, endY, endZ, amount, "==", filter, whitelist);
    }

    @ZenCodeType.Method
    default public T destroyBlockOnStart(String[] filter, boolean whitelist, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withBlockRequirement(RequirementIOMode.INPUT, BlockRequirement.ACTION.DESTROY, "", startX, startY, startZ, endX, endY, endZ, amount, "==", filter, whitelist);
    }

    @ZenCodeType.Method
    default public T destroyBlockOnEnd(String[] filter, boolean whitelist, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withBlockRequirement(RequirementIOMode.OUTPUT, BlockRequirement.ACTION.DESTROY, "", startX, startY, startZ, endX, endY, endZ, amount, "==", filter, whitelist);
    }

    @ZenCodeType.Method
    default public T breakBlockOnStart(String[] filter, boolean whitelist, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withBlockRequirement(RequirementIOMode.INPUT, BlockRequirement.ACTION.BREAK, "", startX, startY, startZ, endX, endY, endZ, amount, "==", filter, whitelist);
    }

    @ZenCodeType.Method
    default public T breakBlockOnEnd(String[] filter, boolean whitelist, int startX, int startY, int startZ, int endX, int endY, int endZ, @ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withBlockRequirement(RequirementIOMode.OUTPUT, BlockRequirement.ACTION.BREAK, "", startX, startY, startZ, endX, endY, endZ, amount, "==", filter, whitelist);
    }

    private T withBlockRequirement(RequirementIOMode mode, BlockRequirement.ACTION action, String block, int startX, int startY, int startZ, int endX, int endY, int endZ, int amount, String comparator, String[] stringFilter, boolean whitelist) {
        PartialBlockState state = block.isEmpty() ? PartialBlockState.AIR : (PartialBlockState)PartialBlockState.CODEC.read(JsonOps.INSTANCE, new JsonPrimitive(block)).resultOrPartial(arg_0 -> ((Logger)CraftTweakerAPI.LOGGER).error(arg_0)).orElse(null);
        if (state == null) {
            return this.error("Invalid block: {}", block);
        }
        AABB bb = new AABB((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
        List<Object> filter = stringFilter != null ? Arrays.stream(stringFilter).map(s -> IIngredient.BLOCK.read(JsonOps.INSTANCE, new JsonPrimitive(s)).resultOrPartial(arg_0 -> ((Logger)CraftTweakerAPI.LOGGER).error(arg_0)).orElse(null)).filter(Objects::nonNull).toList() : Collections.emptyList();
        try {
            return this.addRequirement(new BlockRequirement(mode, action, bb, amount, ComparatorMode.value(comparator), state, filter, whitelist));
        }
        catch (IllegalArgumentException e) {
            return this.error("Invalid comparator: {}", comparator);
        }
    }
}

