/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.tag.MCTag;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.integration.crafttweaker.CTUtils;
import fr.frinn.custommachinery.common.requirement.FluidRequirement;
import fr.frinn.custommachinery.common.util.ingredient.FluidIngredient;
import fr.frinn.custommachinery.common.util.ingredient.FluidTagIngredient;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Fluid")
public interface FluidRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T requireFluid(Fluid fluid, long amount, @ZenCodeType.Optional IData data, @ZenCodeType.OptionalString String tank) {
        return this.addRequirement(new FluidRequirement(RequirementIOMode.INPUT, new FluidIngredient(fluid), amount, CTUtils.getNBT(data), tank));
    }

    @ZenCodeType.Method
    default public T requireFluidTag(MCTag tag, long amount, @ZenCodeType.Optional IData data, @ZenCodeType.OptionalString String tank) {
        try {
            return this.addRequirement(new FluidRequirement(RequirementIOMode.INPUT, FluidTagIngredient.create((TagKey<Fluid>)tag.getTagKey()), amount, CTUtils.getNBT(data), tank));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }

    @ZenCodeType.Method
    default public T produceFluid(Fluid fluid, long amount, @ZenCodeType.Optional IData data, @ZenCodeType.OptionalString String tank) {
        return this.addRequirement(new FluidRequirement(RequirementIOMode.OUTPUT, new FluidIngredient(fluid), amount, CTUtils.getNBT(data), tank));
    }
}

