/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import com.google.common.collect.ImmutableList;
import dev.latvian.mods.kubejs.event.EventJS;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.api.upgrade.IRecipeModifier;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.RecipeModifier;
import fr.frinn.custommachinery.common.upgrade.modifier.AdditionRecipeModifier;
import fr.frinn.custommachinery.common.upgrade.modifier.ExponentialRecipeModifier;
import fr.frinn.custommachinery.common.upgrade.modifier.MultiplicationRecipeModifier;
import fr.frinn.custommachinery.common.upgrade.modifier.SpeedRecipeModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class CustomMachineUpgradeJSBuilder {
    private final Item item;
    private List<Component> tooltips;
    private final List<ResourceLocation> machines;
    private final List<RecipeModifier> modifiers;
    private final int maxAmount;

    public CustomMachineUpgradeJSBuilder(Item item, int maxAmount) {
        this.item = item;
        this.tooltips = Collections.singletonList(Component.m_237115_((String)"custommachinery.upgrade.tooltip").m_130940_(ChatFormatting.AQUA));
        this.maxAmount = maxAmount;
        this.machines = new ArrayList<ResourceLocation>();
        this.modifiers = new ArrayList<RecipeModifier>();
    }

    public MachineUpgrade build() {
        if (this.machines.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 machine for machine upgrade item: " + Registry.f_122827_.m_7981_((Object)this.item));
        }
        if (this.modifiers.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 recipe modifier for machine upgrade item: " + Registry.f_122827_.m_7981_((Object)this.item));
        }
        return new MachineUpgrade(this.item, this.machines, this.modifiers, this.tooltips, this.maxAmount);
    }

    public CustomMachineUpgradeJSBuilder machine(String ... string) {
        for (String s : string) {
            ResourceLocation machine;
            try {
                machine = new ResourceLocation(s);
            }
            catch (ResourceLocationException e) {
                throw new IllegalArgumentException("Invalid Machine ID: " + s + "\n" + e.getMessage());
            }
            this.machines.add(machine);
        }
        return this;
    }

    public CustomMachineUpgradeJSBuilder tooltip(Component ... components) {
        this.tooltips = ImmutableList.copyOf((Object[])components);
        return this;
    }

    public CustomMachineUpgradeJSBuilder modifier(JSRecipeModifierBuilder builder) {
        this.modifiers.add(builder.build());
        return this;
    }

    public static class JSRecipeModifierBuilder {
        private final RequirementType<?> requirement;
        private final RequirementIOMode mode;
        private final IRecipeModifier.OPERATION operation;
        private final double modifier;
        private String target = "";
        private double chance = 1.0;
        private double max = Double.POSITIVE_INFINITY;
        private double min = Double.NEGATIVE_INFINITY;
        private Component tooltip = null;

        private JSRecipeModifierBuilder(RequirementType<?> type, RequirementIOMode mode, IRecipeModifier.OPERATION operation, double modifier) {
            this.requirement = type;
            this.mode = mode;
            this.operation = operation;
            this.modifier = modifier;
        }

        private static RequirementType<?> getType(ResourceLocation id) {
            RequirementType type = (RequirementType)Registration.REQUIREMENT_TYPE_REGISTRY.get(id);
            if (type != null) {
                return type;
            }
            throw new IllegalArgumentException("Invalid requirement type: " + id);
        }

        public static JSRecipeModifierBuilder addInput(ResourceLocation type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.ADDITION, modifier);
        }

        public static JSRecipeModifierBuilder mulInput(ResourceLocation type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.MULTIPLICATION, modifier);
        }

        public static JSRecipeModifierBuilder expInput(ResourceLocation type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.EXPONENTIAL, modifier);
        }

        public static JSRecipeModifierBuilder addOutput(ResourceLocation type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.ADDITION, modifier);
        }

        public static JSRecipeModifierBuilder mulOutput(ResourceLocation type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.MULTIPLICATION, modifier);
        }

        public static JSRecipeModifierBuilder expOutput(ResourceLocation type, double modifier) {
            return new JSRecipeModifierBuilder(JSRecipeModifierBuilder.getType(type), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.EXPONENTIAL, modifier);
        }

        public JSRecipeModifierBuilder target(String target) {
            this.target = target;
            return this;
        }

        public JSRecipeModifierBuilder chance(double chance) {
            this.chance = chance;
            return this;
        }

        public JSRecipeModifierBuilder max(double max) {
            this.max = max;
            return this;
        }

        public JSRecipeModifierBuilder min(double min) {
            this.min = min;
            return this;
        }

        public JSRecipeModifierBuilder tooltip(Component tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        private RecipeModifier build() {
            if (this.requirement == Registration.SPEED_REQUIREMENT.get()) {
                return new SpeedRecipeModifier(this.operation, this.modifier, this.chance, this.max, this.min, this.tooltip);
            }
            return switch (this.operation) {
                default -> throw new IncompatibleClassChangeError();
                case IRecipeModifier.OPERATION.ADDITION -> new AdditionRecipeModifier(this.requirement, this.mode, this.modifier, this.target, this.chance, this.max, this.min, this.tooltip);
                case IRecipeModifier.OPERATION.MULTIPLICATION -> new MultiplicationRecipeModifier(this.requirement, this.mode, this.modifier, this.target, this.chance, this.max, this.min, this.tooltip);
                case IRecipeModifier.OPERATION.EXPONENTIAL -> new ExponentialRecipeModifier(this.requirement, this.mode, this.modifier, this.target, this.chance, this.max, this.min, this.tooltip);
            };
        }
    }

    public static class UpgradeEvent
    extends EventJS {
        private final List<CustomMachineUpgradeJSBuilder> builders = new ArrayList<CustomMachineUpgradeJSBuilder>();

        public CustomMachineUpgradeJSBuilder create(Item item) {
            CustomMachineUpgradeJSBuilder builder = new CustomMachineUpgradeJSBuilder(item, 64);
            this.builders.add(builder);
            return builder;
        }

        public CustomMachineUpgradeJSBuilder create(Item item, int maxAmount) {
            CustomMachineUpgradeJSBuilder builder = new CustomMachineUpgradeJSBuilder(item, maxAmount);
            this.builders.add(builder);
            return builder;
        }

        public List<CustomMachineUpgradeJSBuilder> getBuilders() {
            return this.builders;
        }
    }
}

