/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import fr.frinn.custommachinery.common.integration.kubejs.CustomMachineUpgradeJSBuilder;
import fr.frinn.custommachinery.common.integration.kubejs.CustomMachineryKubeJSPlugin;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class KubeJSIntegration {
    public static List<MachineUpgrade> collectMachineUpgrades() {
        ScriptType.SERVER.console.info((Object)"Collecting Custom Machine upgrades from JS scripts.");
        CustomMachineUpgradeJSBuilder.UpgradeEvent event = new CustomMachineUpgradeJSBuilder.UpgradeEvent();
        CustomMachineryKubeJSPlugin.UPGRADES.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)event);
        ArrayList<MachineUpgrade> upgrades = new ArrayList();
        try {
            upgrades = event.getBuilders().stream().map(CustomMachineUpgradeJSBuilder::build).toList();
        }
        catch (Exception e) {
            ScriptType.SERVER.console.warn("Couldn't build machine upgrade", (Throwable)e);
        }
        ScriptType.SERVER.console.infof((Object)"Successfully added %s Custom Machine upgrades", new Object[]{event.getBuilders().size()});
        return upgrades;
    }

    @Nullable
    public static CompoundTag nbtFromStack(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || nbt.m_128456_()) {
            return null;
        }
        if (nbt.m_128425_("Damage", 3) && nbt.m_128451_("Damage") == 0) {
            nbt.m_128473_("Damage");
        }
        if (nbt.m_128456_()) {
            return null;
        }
        return nbt;
    }

    public static Path getMachineJsonPath(ResourceLocation location) {
        return KubeJSPaths.DIRECTORY.resolve(String.format("%s/%s/%s", PackType.SERVER_DATA.m_10305_(), location.m_135827_(), location.m_135815_()));
    }
}

