/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import dev.architectury.utils.GameInstance;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.UpgradedCustomMachine;
import fr.frinn.custommachinery.common.util.CustomJsonReloadListener;
import fr.frinn.custommachinery.common.util.MachineList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import oshi.util.tuples.Triplet;

public class CustomMachineJsonReloadListener
extends CustomJsonReloadListener {
    private static final String MAIN_PACKNAME = "main";

    public CustomMachineJsonReloadListener() {
        super("machines");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ICustomMachineryAPI.INSTANCE.logger().info("Reading Custom Machinery Machines...");
        CustomMachinery.MACHINES.clear();
        ArrayList upgradedMachines = new ArrayList();
        map.forEach((id, json) -> {
            String packName = this.getPackName(resourceManager, (ResourceLocation)id);
            ICustomMachineryAPI.INSTANCE.logger().info("Parsing machine json: {} in datapack: {}", id, (Object)packName);
            if (!json.isJsonObject()) {
                ICustomMachineryAPI.INSTANCE.logger().error("Bad machine JSON: {} must be a json object and not an array or primitive, skipping...", id);
                return;
            }
            JsonObject jsonObject = (JsonObject)json;
            if (CustomMachinery.MACHINES.containsKey(id)) {
                ICustomMachineryAPI.INSTANCE.logger().error("A machine with id: {} already exists, skipping...", id);
                return;
            }
            if (jsonObject.has("parent") && jsonObject.get("parent").isJsonPrimitive() && jsonObject.getAsJsonPrimitive("parent").isString()) {
                String parent = jsonObject.getAsJsonPrimitive("parent").getAsString();
                try {
                    ResourceLocation parentID = new ResourceLocation(parent);
                    if (map.containsKey(parentID)) {
                        upgradedMachines.add(new Triplet((Object)parentID, id, (Object)jsonObject));
                    } else {
                        ICustomMachineryAPI.INSTANCE.logger().error("Upgraded machine '{}' reference parent machine '{}' which doesn't exist, skipping", id, (Object)parentID);
                    }
                    return;
                }
                catch (ResourceLocationException e) {
                    ICustomMachineryAPI.INSTANCE.logger().error("Invalid parent ID '{}' in machine json '{}', skipping...\n{}", (Object)parent, id, (Object)e.getMessage());
                    return;
                }
            }
            DataResult<CustomMachine> result = CustomMachine.CODEC.read(JsonOps.INSTANCE, json);
            if (result.result().isPresent()) {
                CustomMachine machine = (CustomMachine)result.result().get();
                if (packName.equals(MAIN_PACKNAME)) {
                    machine.setLocation(MachineLocation.fromDefault(id));
                } else {
                    machine.setLocation(MachineLocation.fromDatapack(id, packName));
                }
                CustomMachinery.MACHINES.put((ResourceLocation)id, machine);
                ICustomMachineryAPI.INSTANCE.logger().info("Successfully parsed machine json: {}", id);
                return;
            }
            if (result.error().isPresent()) {
                ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing machine json: {}, skipping...\n{}", id, (Object)((DataResult.PartialResult)result.error().get()).message());
                return;
            }
            throw new IllegalStateException("No success nor error when parsing machine json: " + id + ". This can't happen.");
        });
        while (!upgradedMachines.isEmpty()) {
            Iterator iterator = upgradedMachines.iterator();
            while (iterator.hasNext()) {
                Triplet triplet = (Triplet)iterator.next();
                CustomMachine parent = CustomMachinery.MACHINES.get(triplet.getA());
                if (parent == null) {
                    upgradedMachines.stream().filter(t -> ((ResourceLocation)t.getB()).equals(triplet.getA())).findFirst().ifPresentOrElse(t -> {
                        if (((ResourceLocation)t.getA()).equals(triplet.getB())) {
                            ICustomMachineryAPI.INSTANCE.logger().error("Circular reference in upgraded machines '{}' and '{}' both referencing each other as parent", triplet.getB(), t.getA());
                            iterator.remove();
                        }
                    }, () -> {
                        ICustomMachineryAPI.INSTANCE.logger().error("Upgraded machine '{}' reference parent machine '{}' which doesn't exist, skipping", triplet.getB(), triplet.getA());
                        iterator.remove();
                    });
                    continue;
                }
                ResourceLocation id2 = (ResourceLocation)triplet.getB();
                DataResult<UpgradedCustomMachine> result = UpgradedCustomMachine.makeCodec(parent).read(JsonOps.INSTANCE, (JsonElement)triplet.getC());
                if (result.result().isPresent()) {
                    CustomMachine machine = (CustomMachine)result.result().get();
                    String packName = this.getPackName(resourceManager, id2);
                    if (packName.equals(MAIN_PACKNAME)) {
                        machine.setLocation(MachineLocation.fromDefault(id2));
                    } else {
                        machine.setLocation(MachineLocation.fromDatapack(id2, packName));
                    }
                    CustomMachinery.MACHINES.put(id2, machine);
                    ICustomMachineryAPI.INSTANCE.logger().info("Successfully parsed machine json: {}", (Object)id2);
                } else if (result.error().isPresent()) {
                    ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing machine json: {}, skipping...\n{}", (Object)id2, (Object)((DataResult.PartialResult)result.error().get()).message());
                }
                iterator.remove();
            }
        }
        ICustomMachineryAPI.INSTANCE.logger().info("Finished creating {} custom machines.", (Object)CustomMachinery.MACHINES.keySet().size());
        if (GameInstance.getServer() != null) {
            MachineList.setNeedRefresh();
        }
    }

    private String getPackName(ResourceManager resourceManager, ResourceLocation id) {
        try {
            return resourceManager.m_215593_(new ResourceLocation(id.m_135827_(), "machines/" + id.m_135815_() + ".json")).m_215506_();
        }
        catch (IOException e) {
            return MAIN_PACKNAME;
        }
    }
}

