/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.io.File;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MachineLocation {
    public static final NamedCodec<MachineLocation> CODEC = NamedCodec.record(machineLocationInstance -> machineLocationInstance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("id").forGetter(MachineLocation::getId), Loader.CODEC.fieldOf("loader").forGetter(MachineLocation::getLoader), NamedCodec.STRING.fieldOf("packName").forGetter(MachineLocation::getPackName)).apply((Applicative)machineLocationInstance, MachineLocation::new), "Machine location");
    private final ResourceLocation id;
    private final Loader loader;
    private final String packName;

    private MachineLocation(ResourceLocation id, Loader loader, String packName) {
        this.id = id;
        this.loader = loader;
        this.packName = packName;
    }

    public static MachineLocation fromLoader(Loader loader, ResourceLocation id, String packName) {
        return switch (loader) {
            default -> throw new IncompatibleClassChangeError();
            case Loader.DEFAULT -> MachineLocation.fromDefault(id);
            case Loader.DATAPACK -> MachineLocation.fromDatapack(id, packName);
            case Loader.CRAFTTWEAKER -> MachineLocation.fromCraftTweaker(id);
            case Loader.KUBEJS -> MachineLocation.fromKubeJS(id);
        };
    }

    public static MachineLocation fromDefault(ResourceLocation id) {
        return new MachineLocation(id, Loader.DEFAULT, "");
    }

    public static MachineLocation fromDatapack(ResourceLocation id, String packName) {
        return new MachineLocation(id, Loader.DATAPACK, packName);
    }

    public static MachineLocation fromCraftTweaker(ResourceLocation id) {
        return new MachineLocation(id, Loader.CRAFTTWEAKER, "");
    }

    public static MachineLocation fromKubeJS(ResourceLocation id) {
        return new MachineLocation(id, Loader.KUBEJS, "");
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public String getPackName() {
        return this.packName;
    }

    public String getPath() {
        return this.packName + File.separator + "data" + File.separator + this.id.m_135827_() + File.separator + "machines" + File.separator + this.id.m_135815_() + ".json";
    }

    public static enum Loader {
        DEFAULT,
        DATAPACK,
        CRAFTTWEAKER,
        KUBEJS;

        public static final NamedCodec<Loader> CODEC;

        public Component getTranslatedName() {
            return Component.m_237115_((String)("custommachinery.machine.loader." + this.name().toLowerCase(Locale.ENGLISH)));
        }

        public int getColor() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DEFAULT -> ChatFormatting.BLACK.m_126665_();
                case DATAPACK -> ChatFormatting.DARK_GREEN.m_126665_();
                case KUBEJS -> ChatFormatting.DARK_PURPLE.m_126665_();
                case CRAFTTWEAKER -> ChatFormatting.DARK_AQUA.m_126665_();
            };
        }

        public static Loader value(String value) {
            return Loader.valueOf(value.toUpperCase(Locale.ENGLISH));
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = NamedCodec.enumCodec(Loader.class);
        }
    }
}

