/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine.builder.component;

import com.google.common.collect.Lists;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.component.builder.IComponentBuilderProperty;
import fr.frinn.custommachinery.api.component.builder.IMachineComponentBuilder;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.component.variant.item.DefaultItemComponentVariant;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.component.builder.IntComponentBuilderProperty;
import fr.frinn.custommachinery.impl.component.builder.ModeComponentBuilderProperty;
import fr.frinn.custommachinery.impl.component.builder.StringComponentBuilderProperty;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;

public class ItemComponentBuilder
implements IMachineComponentBuilder<ItemMachineComponent> {
    private StringComponentBuilderProperty id = new StringComponentBuilderProperty("id", "");
    private IntComponentBuilderProperty capacity = new IntComponentBuilderProperty("capacity", 64);
    private ModeComponentBuilderProperty mode = new ModeComponentBuilderProperty("mode", ComponentIOMode.BOTH);
    private List<IComponentBuilderProperty<?>> properties = Lists.newArrayList((Object[])new IComponentBuilderProperty[]{this.id, this.capacity, this.mode});

    public ItemComponentBuilder fromComponent(IMachineComponent component) {
        if (component instanceof ItemMachineComponent) {
            ItemMachineComponent itemComponent = (ItemMachineComponent)component;
            this.id.set(itemComponent.getId());
            this.capacity.set(itemComponent.getCapacity());
            this.mode.set(itemComponent.getMode());
        }
        return this;
    }

    @Override
    public MachineComponentType<ItemMachineComponent> getType() {
        return (MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get();
    }

    @Override
    public List<IComponentBuilderProperty<?>> getProperties() {
        return this.properties;
    }

    @Override
    public IMachineComponentTemplate<ItemMachineComponent> build() {
        return new ItemMachineComponent.Template((String)this.id.get(), (ComponentIOMode)((Object)this.mode.get()), (Integer)this.capacity.get(), (Integer)this.capacity.get(), (Integer)this.capacity.get(), new ArrayList<IIngredient<Item>>(), false, DefaultItemComponentVariant.INSTANCE, null, false);
    }
}

