/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.network.SUpdateMachinesPacket;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.Utils;
import io.netty.handler.codec.EncoderException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CAddMachinePacket
extends BaseC2SMessage {
    private final ResourceLocation id;
    private final CustomMachine machine;
    private final boolean shouldReload;
    private final boolean writeToFile;

    public CAddMachinePacket(ResourceLocation id, CustomMachine machine, boolean shouldReload, boolean writeToFile) {
        this.id = id;
        this.machine = machine;
        this.shouldReload = shouldReload;
        this.writeToFile = writeToFile;
    }

    public MessageType getType() {
        return PacketManager.ADD_MACHINE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        try {
            MachineLocation.CODEC.toNetwork(this.machine.getLocation(), buf);
            CustomMachine.CODEC.toNetwork(this.machine, buf);
        }
        catch (EncoderException e) {
            e.printStackTrace();
        }
        buf.writeBoolean(this.shouldReload);
        buf.writeBoolean(this.writeToFile);
    }

    public static CAddMachinePacket read(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        CustomMachine machine = CustomMachine.DUMMY;
        try {
            MachineLocation location = MachineLocation.CODEC.fromNetwork(buf);
            machine = CustomMachine.CODEC.fromNetwork(buf).setLocation(location);
        }
        catch (EncoderException e) {
            e.printStackTrace();
        }
        boolean shouldReload = buf.readBoolean();
        boolean writeToFile = buf.readBoolean();
        return new CAddMachinePacket(id, machine, shouldReload, writeToFile);
    }

    public void handle(NetworkManager.PacketContext context) {
        Player player;
        if (context.getEnvironment() == Env.SERVER && (player = context.getPlayer()) != null && player.m_20194_() != null && Utils.canPlayerManageMachines(player) && this.machine != CustomMachine.DUMMY) {
            context.queue(() -> {
                CustomMachinery.LOGGER.info("Player: " + player.m_5446_().getString() + " added new Machine: " + this.id);
                CustomMachinery.MACHINES.put(this.id, this.machine);
                if (this.shouldReload) {
                    new SUpdateMachinesPacket(CustomMachinery.MACHINES).sendToAll(player.m_20194_());
                }
                if (this.writeToFile && this.machine.getLocation().getLoader() == MachineLocation.Loader.DATAPACK) {
                    FileUtils.writeMachineJSON(player.m_20194_(), this.machine);
                }
            });
        }
    }
}

