/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.guielement.ButtonGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.util.TaskDelayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CButtonGuiElementPacket
extends BaseC2SMessage {
    private final String id;
    private final boolean toogle;

    public CButtonGuiElementPacket(String id, boolean toogle) {
        this.id = id;
        this.toogle = toogle;
    }

    public MessageType getType() {
        return PacketManager.UPDATE_MACHINE_DATA;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.id);
        buf.writeBoolean(this.toogle);
    }

    public static CButtonGuiElementPacket read(FriendlyByteBuf buf) {
        return new CButtonGuiElementPacket(buf.m_130277_(), buf.readBoolean());
    }

    public void handle(NetworkManager.PacketContext context) {
        AbstractContainerMenu abstractContainerMenu;
        if (context.getEnvironment() == Env.SERVER && context.getPlayer().m_20194_() != null && (abstractContainerMenu = context.getPlayer().f_36096_) instanceof CustomMachineContainer) {
            CustomMachineContainer container = (CustomMachineContainer)abstractContainerMenu;
            int holdTime = container.getTile().getGuiElements().stream().filter(element -> {
                ButtonGuiElement button;
                return element instanceof ButtonGuiElement && (button = (ButtonGuiElement)element).getId().equals(this.id);
            }).findFirst().map(element -> ((ButtonGuiElement)element).getHoldTime()).orElse(-1);
            if (holdTime == -1) {
                return;
            }
            container.getTile().getComponentManager().getComponent((MachineComponentType)Registration.DATA_MACHINE_COMPONENT.get()).ifPresent(component -> {
                if (this.toogle) {
                    component.getData().m_128379_(this.id, !component.getData().m_128471_(this.id));
                } else {
                    component.getData().m_128379_(this.id, true);
                    component.getManager().markDirty();
                    TaskDelayer.enqueue(holdTime, () -> {
                        component.getData().m_128379_(this.id, false);
                        component.getManager().markDirty();
                    });
                }
            });
        }
    }
}

