/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CChangeSideModePacket
extends BaseC2SMessage {
    private final int containerID;
    private final String id;
    private final byte side;
    private final boolean next;

    public CChangeSideModePacket(int containerID, String id, byte side, boolean next) {
        this.containerID = containerID;
        this.id = id;
        this.side = side;
        this.next = next;
    }

    public MessageType getType() {
        return PacketManager.CHANGE_SIDE_MODE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.containerID);
        buf.m_130070_(this.id);
        buf.writeByte((int)this.side);
        buf.writeBoolean(this.next);
    }

    public static CChangeSideModePacket read(FriendlyByteBuf buf) {
        return new CChangeSideModePacket(buf.m_130242_(), buf.m_130277_(), buf.readByte(), buf.readBoolean());
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnvironment() == Env.SERVER) {
            context.queue(() -> {
                CustomMachineContainer container;
                Optional<ISideConfigComponent> component;
                AbstractContainerMenu patt2015$temp;
                Player player = context.getPlayer();
                if (player != null && player.f_36096_.f_38840_ == this.containerID && (patt2015$temp = player.f_36096_) instanceof CustomMachineContainer && (component = (container = (CustomMachineContainer)patt2015$temp).getTile().getComponentManager().getConfigComponentById(this.id)).isPresent()) {
                    SideConfig config = component.get().getConfig();
                    switch (this.side) {
                        case 6: {
                            config.setAutoInput(!config.isAutoInput());
                            break;
                        }
                        case 7: {
                            config.setAutoOutput(!config.isAutoOutput());
                            break;
                        }
                        default: {
                            RelativeSide side = RelativeSide.values()[this.side];
                            if (this.next) {
                                config.setSideMode(side, config.getSideMode(side).next());
                                break;
                            }
                            config.setSideMode(side, config.getSideMode(side).previous());
                        }
                    }
                }
            });
        }
    }
}

