/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CRemoveMachinePacket
extends BaseC2SMessage {
    private final ResourceLocation id;

    public CRemoveMachinePacket(ResourceLocation id) {
        this.id = id;
    }

    public MessageType getType() {
        return PacketManager.REMOVE_MACHINE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
    }

    public static CRemoveMachinePacket read(FriendlyByteBuf buf) {
        return new CRemoveMachinePacket(buf.m_130281_());
    }

    public void handle(NetworkManager.PacketContext context) {
        Player player;
        if (context.getEnvironment() == Env.SERVER && (player = context.getPlayer()) != null && player.m_20194_() != null && Utils.canPlayerManageMachines(player)) {
            context.queue(() -> {
                CustomMachinery.LOGGER.info("Player: {} removed machine: {}", (Object)player.m_5446_().getString(), (Object)this.id);
                CustomMachinery.MACHINES.remove(this.id);
                FileUtils.deleteMachineJSON(player.m_20194_(), this.id);
            });
        }
    }
}

