/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import com.mojang.datafixers.util.Pair;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.util.LootTableHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SLootTablesPacket
extends BaseS2CMessage {
    private final Map<ResourceLocation, List<Pair<ItemStack, Double>>> loots;

    public SLootTablesPacket(Map<ResourceLocation, List<Pair<ItemStack, Double>>> loots) {
        this.loots = loots;
    }

    public MessageType getType() {
        return PacketManager.LOOT_TABLES;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.loots.size());
        this.loots.forEach((id, loots) -> {
            buf.m_130085_(id);
            buf.m_130130_(loots.size());
            loots.forEach(pair -> {
                buf.m_130055_((ItemStack)pair.getFirst());
                buf.writeDouble(((Double)pair.getSecond()).doubleValue());
            });
        });
    }

    public static SLootTablesPacket read(FriendlyByteBuf buf) {
        HashMap<ResourceLocation, List<Pair<ItemStack, Double>>> loots = new HashMap<ResourceLocation, List<Pair<ItemStack, Double>>>();
        int lootSize = buf.m_130242_();
        for (int i = 0; i < lootSize; ++i) {
            ResourceLocation id = buf.m_130281_();
            ArrayList<Pair> stacks = new ArrayList<Pair>();
            int stackSize = buf.m_130242_();
            for (int j = 0; j < stackSize; ++j) {
                stacks.add(Pair.of((Object)buf.m_130267_(), (Object)buf.readDouble()));
            }
            loots.put(id, stacks);
        }
        return new SLootTablesPacket(loots);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnvironment() == Env.CLIENT) {
            context.queue(() -> LootTableHelper.receiveLoots(this.loots));
        }
    }
}

