/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.PositionMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public class BiomeRequirement
extends AbstractRequirement<PositionMachineComponent>
implements IDisplayInfoRequirement {
    public static final NamedCodec<BiomeRequirement> CODEC = NamedCodec.record(biomeRequirementInstance -> biomeRequirementInstance.group(DefaultCodecs.RESOURCE_LOCATION.listOf().fieldOf("filter").forGetter(requirement -> requirement.filter), NamedCodec.BOOL.optionalFieldOf("blacklist", false).forGetter(requirement -> requirement.blacklist)).apply((Applicative)biomeRequirementInstance, BiomeRequirement::new), "Biome requirement");
    private final List<ResourceLocation> filter;
    private final boolean blacklist;

    public BiomeRequirement(List<ResourceLocation> filter, boolean blacklist) {
        super(RequirementIOMode.INPUT);
        this.filter = filter;
        this.blacklist = blacklist;
    }

    @Override
    public RequirementType<BiomeRequirement> getType() {
        return (RequirementType)Registration.BIOME_REQUIREMENT.get();
    }

    @Override
    public boolean test(PositionMachineComponent component, ICraftingContext context) {
        Registry biomeRegistry = component.getManager().getLevel().m_5962_().m_175515_(Registry.f_122885_);
        return this.filter.stream().anyMatch(biome -> biomeRegistry.m_7745_(biome) == component.getBiome()) != this.blacklist;
    }

    @Override
    public CraftingResult processStart(PositionMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(PositionMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<PositionMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.POSITION_MACHINE_COMPONENT.get();
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        if (!this.filter.isEmpty()) {
            if (this.blacklist) {
                info.addTooltip((Component)Component.m_237115_((String)"custommachinery.requirements.position.info.biome.blacklist").m_130940_(ChatFormatting.AQUA));
            } else {
                info.addTooltip((Component)Component.m_237115_((String)"custommachinery.requirements.position.info.biome.whitelist").m_130940_(ChatFormatting.AQUA));
            }
            this.filter.forEach(biome -> info.addTooltip((Component)Component.m_237113_((String)"* ").m_7220_((Component)Component.m_237115_((String)("biome." + biome.m_135827_() + "." + biome.m_135815_())))));
        }
        info.setItemIcon(Items.f_42676_);
    }
}

