/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.EffectMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.RomanNumber;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;

public class EffectRequirement
extends AbstractDelayedChanceableRequirement<EffectMachineComponent>
implements ITickableRequirement<EffectMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<EffectRequirement> CODEC = NamedCodec.record(effectRequirementInstance -> effectRequirementInstance.group(RegistrarCodec.EFFECT.fieldOf("effect").forGetter(requirement -> requirement.effect), NamedCodec.INT.fieldOf("time").forGetter(requirement -> requirement.time), NamedCodec.INT.fieldOf("radius").forGetter(requirement -> requirement.radius), NamedCodec.INT.optionalFieldOf("level", 1).forGetter(requirement -> requirement.level), RegistrarCodec.ENTITY.listOf().optionalFieldOf("filter", new ArrayList()).forGetter(requirement -> requirement.filter), NamedCodec.BOOL.optionalFieldOf("finish", false).forGetter(requirement -> requirement.applyAtEnd), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("delay", 0.0).forGetter(AbstractDelayedRequirement::getDelay), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractDelayedChanceableRequirement::getChance)).apply((Applicative)effectRequirementInstance, (effect, time, radius, level, filter, finish, delay, chance) -> {
        EffectRequirement requirement = new EffectRequirement((MobEffect)effect, (int)time, (int)radius, (int)level, (List<EntityType<?>>)filter, (boolean)finish);
        requirement.setDelay((double)delay);
        requirement.setChance((double)chance);
        return requirement;
    }), "Effect requirement");
    private final MobEffect effect;
    private final int time;
    private final int level;
    private final int radius;
    private final List<EntityType<?>> filter;
    private final boolean applyAtEnd;

    public EffectRequirement(MobEffect effect, int time, int level, int radius, List<EntityType<?>> filter, boolean applyAtEnd) {
        super(RequirementIOMode.OUTPUT);
        this.effect = effect;
        this.time = time;
        this.level = level;
        this.radius = radius;
        this.filter = filter;
        this.applyAtEnd = applyAtEnd;
    }

    @Override
    public RequirementType<EffectRequirement> getType() {
        return (RequirementType)Registration.EFFECT_REQUIREMENT.get();
    }

    @Override
    public boolean test(EffectMachineComponent component, ICraftingContext context) {
        return true;
    }

    @Override
    public CraftingResult processStart(EffectMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(EffectMachineComponent component, ICraftingContext context) {
        if (this.applyAtEnd && this.getDelay() == 0.0) {
            int time = (int)context.getIntegerModifiedValue(this.time, this, "time");
            int level = Mth.m_14045_((int)((int)context.getIntegerModifiedValue(this.level, this, "level") - 1), (int)0, (int)255);
            int radius = (int)context.getIntegerModifiedValue(this.radius, this, "radius");
            component.applyEffect(new MobEffectInstance(this.effect, time, level - 1), radius, entity -> this.filter.isEmpty() || this.filter.contains(entity.m_6095_()));
        }
        return CraftingResult.success();
    }

    @Override
    public CraftingResult processTick(EffectMachineComponent component, ICraftingContext context) {
        if (!this.applyAtEnd && this.getDelay() == 0.0) {
            int time = (int)context.getPerTickIntegerModifiedValue(this.time, this, "time");
            int level = Mth.m_14045_((int)((int)context.getPerTickIntegerModifiedValue(this.level, this, "level") - 1), (int)0, (int)255);
            int radius = (int)context.getPerTickIntegerModifiedValue(this.radius, this, "radius");
            component.applyEffect(new MobEffectInstance(this.effect, time, level), radius, entity -> this.filter.isEmpty() || this.filter.contains(entity.m_6095_()));
        }
        return CraftingResult.success();
    }

    @Override
    public CraftingResult execute(EffectMachineComponent component, ICraftingContext context) {
        int time = (int)context.getPerTickIntegerModifiedValue(this.time, this, "time");
        int level = Mth.m_14045_((int)((int)context.getPerTickIntegerModifiedValue(this.level, this, "level") - 1), (int)0, (int)255);
        int radius = (int)context.getPerTickIntegerModifiedValue(this.radius, this, "radius");
        component.applyEffect(new MobEffectInstance(this.effect, time, level), radius, entity -> this.filter.isEmpty() || this.filter.contains(entity.m_6095_()));
        return CraftingResult.success();
    }

    @Override
    public MachineComponentType<EffectMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.EFFECT_MACHINE_COMPONENT.get();
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        MutableComponent level;
        MutableComponent effect = Component.m_237113_((String)this.effect.m_19482_().getString()).m_130940_(ChatFormatting.AQUA);
        MutableComponent mutableComponent = level = this.level <= 0 ? Component.m_237119_() : Component.m_237113_((String)RomanNumber.toRoman(this.level)).m_130940_(ChatFormatting.GOLD);
        if (this.applyAtEnd) {
            info.addTooltip((Component)Component.m_237110_((String)"custommachinery.requirements.effect.info.end", (Object[])new Object[]{effect, level, this.time, this.radius}));
        } else {
            info.addTooltip((Component)Component.m_237110_((String)"custommachinery.requirements.effect.info.tick", (Object[])new Object[]{effect, level, this.time, this.radius}));
        }
        if (!this.filter.isEmpty()) {
            info.addTooltip((Component)Component.m_237115_((String)"custommachinery.requirements.effect.info.whitelist").m_130940_(ChatFormatting.AQUA));
            this.filter.forEach(type -> info.addTooltip((Component)Component.m_237113_((String)"* ").m_7220_((Component)Component.m_237115_((String)type.m_20675_()))));
        }
        info.setItemIcon(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43623_));
    }
}

