/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.FluidIngredientWrapper;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.ingredient.FluidTagIngredient;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidPerTickRequirement
extends AbstractChanceableRequirement<FluidComponentHandler>
implements ITickableRequirement<FluidComponentHandler>,
IJEIIngredientRequirement<FluidStack> {
    public static final NamedCodec<FluidPerTickRequirement> CODEC = NamedCodec.record(fluidPerTickRequirementInstance -> fluidPerTickRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(IRequirement::getMode), IIngredient.FLUID.fieldOf("fluid").forGetter(requirement -> requirement.fluid), NamedCodec.LONG.fieldOf("amount").forGetter(requirement -> requirement.amount), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractChanceableRequirement::getChance), DefaultCodecs.COMPOUND_TAG.optionalFieldOf("nbt").forGetter(requirement -> Optional.ofNullable(requirement.nbt)), NamedCodec.STRING.optionalFieldOf("tank", "").forGetter(requirement -> requirement.tank)).apply((Applicative)fluidPerTickRequirementInstance, (mode, fluid, amount, chance, nbt, tank) -> {
        FluidPerTickRequirement requirement = new FluidPerTickRequirement((RequirementIOMode)((Object)((Object)mode)), (IIngredient<Fluid>)fluid, (long)amount, nbt.orElse(null), (String)tank);
        requirement.setChance((double)chance);
        return requirement;
    }), "Fluid per tick requirement");
    private final IIngredient<Fluid> fluid;
    private final long amount;
    @Nullable
    private final CompoundTag nbt;
    private final String tank;

    public FluidPerTickRequirement(RequirementIOMode mode, IIngredient<Fluid> fluid, long amount, @Nullable CompoundTag nbt, String tank) {
        super(mode);
        if (mode == RequirementIOMode.OUTPUT && fluid instanceof FluidTagIngredient) {
            throw new IllegalArgumentException("You can't use a tag for an Output Fluid Per Tick Requirement");
        }
        this.fluid = fluid;
        this.amount = amount;
        this.nbt = nbt;
        this.tank = tank;
    }

    @Override
    public RequirementType<FluidPerTickRequirement> getType() {
        return (RequirementType)Registration.FLUID_PER_TICK_REQUIREMENT.get();
    }

    @Override
    public MachineComponentType getComponentType() {
        return (MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get();
    }

    @Override
    public boolean test(FluidComponentHandler component, ICraftingContext context) {
        long amount = context.getPerTickIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return this.fluid.getAll().stream().mapToLong(fluid -> component.getFluidAmount(this.tank, (Fluid)fluid, this.nbt)).sum() >= amount;
        }
        if (this.fluid.getAll().get(0) != null) {
            return component.getSpaceForFluid(this.tank, this.fluid.getAll().get(0), this.nbt) >= amount;
        }
        throw new IllegalStateException("Can't use output fluid per tick requirement with fluid tag");
    }

    @Override
    public CraftingResult processStart(FluidComponentHandler component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processTick(FluidComponentHandler component, ICraftingContext context) {
        long amount = context.getPerTickIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            long maxDrain = this.fluid.getAll().stream().mapToLong(fluid -> component.getFluidAmount(this.tank, (Fluid)fluid, this.nbt)).sum();
            if (maxDrain >= amount) {
                long toDrain = amount;
                for (Fluid fluid2 : this.fluid.getAll()) {
                    long canDrain = component.getFluidAmount(this.tank, fluid2, this.nbt);
                    if (canDrain <= 0L) continue;
                    canDrain = Math.min(canDrain, toDrain);
                    component.removeFromInputs(this.tank, FluidStack.create((Fluid)fluid2, (long)canDrain, (CompoundTag)this.nbt));
                    if ((toDrain -= canDrain) != 0L) continue;
                    return CraftingResult.success();
                }
            }
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.fluid.error.input", (Object[])new Object[]{this.fluid, amount, maxDrain}));
        }
        if (this.fluid.getAll().get(0) != null) {
            Fluid fluid3 = this.fluid.getAll().get(0);
            FluidStack stack = FluidStack.create((Fluid)fluid3, (long)amount, (CompoundTag)this.nbt);
            long canInsert = component.getSpaceForFluid(this.tank, fluid3, this.nbt);
            if (canInsert >= amount) {
                component.addToOutputs(this.tank, stack);
                return CraftingResult.success();
            }
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.fluidpertick.error.output", (Object[])new Object[]{amount, FluidStackHooks.getName((FluidStack)FluidStack.create((Fluid)fluid3, (long)this.amount))}));
        }
        throw new IllegalStateException("Can't use fluid per tick requirement with fluid tag");
    }

    @Override
    public CraftingResult processEnd(FluidComponentHandler component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public List<IJEIIngredientWrapper<FluidStack>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new FluidIngredientWrapper(this.getMode(), this.fluid, this.amount, this.getChance(), true, this.nbt, this.tank));
    }
}

