/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.FluidIngredientWrapper;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.ingredient.FluidTagIngredient;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidRequirement
extends AbstractChanceableRequirement<FluidComponentHandler>
implements IJEIIngredientRequirement<FluidStack> {
    public static final NamedCodec<FluidRequirement> CODEC = NamedCodec.record(fluidRequirementInstance -> fluidRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(AbstractRequirement::getMode), IIngredient.FLUID.fieldOf("fluid").forGetter(requirement -> requirement.fluid), NamedCodec.LONG.fieldOf("amount").forGetter(requirement -> requirement.amount), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractChanceableRequirement::getChance), DefaultCodecs.COMPOUND_TAG.optionalFieldOf("nbt").forGetter(requirement -> Optional.ofNullable(requirement.nbt)), NamedCodec.STRING.optionalFieldOf("tank", "").forGetter(requirement -> requirement.tank)).apply((Applicative)fluidRequirementInstance, (mode, fluid, amount, chance, nbt, tank) -> {
        FluidRequirement requirement = new FluidRequirement((RequirementIOMode)((Object)((Object)mode)), (IIngredient<Fluid>)fluid, (long)amount, nbt.orElse(null), (String)tank);
        requirement.setChance((double)chance);
        return requirement;
    }), "Fluid requirement");
    private final IIngredient<Fluid> fluid;
    private final long amount;
    @Nullable
    private final CompoundTag nbt;
    private final String tank;

    public FluidRequirement(RequirementIOMode mode, IIngredient<Fluid> fluid, long amount, @Nullable CompoundTag nbt, String tank) {
        super(mode);
        if (mode == RequirementIOMode.OUTPUT && fluid instanceof FluidTagIngredient) {
            throw new IllegalArgumentException("You must specify a fluid for an Output Fluid Requirement");
        }
        this.fluid = fluid;
        this.amount = amount;
        this.nbt = nbt;
        this.tank = tank;
    }

    @Override
    public RequirementType<FluidRequirement> getType() {
        return (RequirementType)Registration.FLUID_REQUIREMENT.get();
    }

    @Override
    public MachineComponentType getComponentType() {
        return (MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get();
    }

    @Override
    public boolean test(FluidComponentHandler component, ICraftingContext context) {
        long amount = context.getIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return this.fluid.getAll().stream().mapToLong(fluid -> component.getFluidAmount(this.tank, (Fluid)fluid, this.nbt)).sum() >= amount;
        }
        if (this.fluid.getAll().get(0) != null) {
            return component.getSpaceForFluid(this.tank, this.fluid.getAll().get(0), this.nbt) >= amount;
        }
        throw new IllegalStateException("Can't use output fluid requirement with fluid tag");
    }

    @Override
    public CraftingResult processStart(FluidComponentHandler component, ICraftingContext context) {
        long amount = context.getIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            long maxDrain = this.fluid.getAll().stream().mapToLong(fluid -> component.getFluidAmount(this.tank, (Fluid)fluid, this.nbt)).sum();
            if (maxDrain >= amount) {
                long toDrain = amount;
                for (Fluid fluid2 : this.fluid.getAll()) {
                    long canDrain = component.getFluidAmount(this.tank, fluid2, this.nbt);
                    if (canDrain <= 0L) continue;
                    canDrain = Math.min(canDrain, toDrain);
                    component.removeFromInputs(this.tank, FluidStack.create((Fluid)fluid2, (long)canDrain, (CompoundTag)this.nbt));
                    if ((toDrain -= canDrain) != 0L) continue;
                    return CraftingResult.success();
                }
            }
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.fluid.error.input", (Object[])new Object[]{this.fluid, amount, maxDrain}));
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(FluidComponentHandler component, ICraftingContext context) {
        long amount = context.getIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.OUTPUT) {
            if (this.fluid.getAll().get(0) != null) {
                Fluid fluid = this.fluid.getAll().get(0);
                long canFill = component.getSpaceForFluid(this.tank, fluid, this.nbt);
                if (canFill >= amount) {
                    FluidStack stack = FluidStack.create((Fluid)fluid, (long)amount, (CompoundTag)this.nbt);
                    component.addToOutputs(this.tank, stack);
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.fluid.error.output", (Object[])new Object[]{amount, FluidStackHooks.getName((FluidStack)FluidStack.create((Fluid)fluid, (long)this.amount))}));
            }
            throw new IllegalStateException("Can't use output fluid requirement with fluid tag");
        }
        return CraftingResult.pass();
    }

    @Override
    public List<IJEIIngredientWrapper<FluidStack>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new FluidIngredientWrapper(this.getMode(), this.fluid, this.amount, this.getChance(), false, this.nbt, this.tank));
    }
}

