/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.LightMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinery.impl.util.IntRange;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;

public class LightRequirement
extends AbstractRequirement<LightMachineComponent>
implements ITickableRequirement<LightMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<LightRequirement> CODEC = NamedCodec.record(lightRequirementInstance -> lightRequirementInstance.group(IntRange.CODEC.fieldOf("light").forGetter(requirement -> requirement.light), NamedCodec.BOOL.optionalFieldOf("sky", false).forGetter(requirement -> requirement.sky)).apply((Applicative)lightRequirementInstance, LightRequirement::new), "Light requirement");
    private final IntRange light;
    private final boolean sky;

    public LightRequirement(IntRange light, boolean sky) {
        super(RequirementIOMode.INPUT);
        this.light = light;
        this.sky = sky;
    }

    @Override
    public RequirementType<?> getType() {
        return (RequirementType)Registration.LIGHT_REQUIREMENT.get();
    }

    @Override
    public boolean test(LightMachineComponent component, ICraftingContext context) {
        if (this.sky) {
            return this.light.contains(component.getSkyLight());
        }
        return this.light.contains(component.getBlockLight());
    }

    @Override
    public CraftingResult processStart(LightMachineComponent component, ICraftingContext context) {
        if (this.test(component, context)) {
            return CraftingResult.success();
        }
        if (this.sky) {
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.light.sky.error", (Object[])new Object[]{this.light.toFormattedString(), component.getSkyLight()}));
        }
        return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.light.block.error", (Object[])new Object[]{this.light, component.getBlockLight()}));
    }

    @Override
    public CraftingResult processEnd(LightMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<LightMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.LIGHT_MACHINE_COMPONENT.get();
    }

    @Override
    public CraftingResult processTick(LightMachineComponent component, ICraftingContext context) {
        if (this.test(component, context)) {
            return CraftingResult.success();
        }
        if (this.sky) {
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.light.sky.error", (Object[])new Object[]{this.light.toFormattedString(), component.getSkyLight()}));
        }
        return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.light.block.error", (Object[])new Object[]{this.light.toFormattedString(), component.getBlockLight()}));
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        if (this.sky) {
            info.addTooltip((Component)Component.m_237110_((String)"custommachinery.requirements.light.sky.info", (Object[])new Object[]{this.light.toFormattedString()}));
        } else {
            info.addTooltip((Component)Component.m_237110_((String)"custommachinery.requirements.light.block.info", (Object[])new Object[]{this.light.toFormattedString()}));
        }
        info.setItemIcon(Items.f_42000_);
    }
}

