/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.LootTableIngredientWrapper;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.LootTableHelper;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LootTableRequirement
extends AbstractRequirement<ItemComponentHandler>
implements IJEIIngredientRequirement<ItemStack> {
    public static final NamedCodec<LootTableRequirement> CODEC = NamedCodec.record(lootTableRequirementInstance -> lootTableRequirementInstance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("table").forGetter(requirement -> requirement.lootTable), NamedCodec.FLOAT.optionalFieldOf("luck", Float.valueOf(0.0f)).forGetter(requirement -> Float.valueOf(requirement.luck))).apply((Applicative)lootTableRequirementInstance, LootTableRequirement::new), "Loottable requirement");
    private final ResourceLocation lootTable;
    private final float luck;
    private List<ItemStack> toOutput = Collections.emptyList();

    public LootTableRequirement(ResourceLocation lootTable, float luck) {
        super(RequirementIOMode.OUTPUT);
        this.lootTable = lootTable;
        this.luck = luck;
        LootTableHelper.addTable(lootTable);
    }

    @Override
    public RequirementType<LootTableRequirement> getType() {
        return (RequirementType)Registration.LOOT_TABLE_REQUIREMENT.get();
    }

    @Override
    public boolean test(ItemComponentHandler component, ICraftingContext context) {
        return true;
    }

    @Override
    public CraftingResult processStart(ItemComponentHandler component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(ItemComponentHandler component, ICraftingContext context) {
        if (this.getMode() == RequirementIOMode.INPUT || context.getMachineTile().m_58904_() == null || context.getMachineTile().m_58904_().m_7654_() == null) {
            return CraftingResult.pass();
        }
        if (this.toOutput.isEmpty()) {
            LootTable table = context.getMachineTile().m_58904_().m_7654_().m_129898_().m_79217_(this.lootTable);
            LootContext lootContext = new LootContext.Builder((ServerLevel)context.getMachineTile().m_58904_()).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)context.getMachineTile().m_58899_())).m_78972_(LootContextParams.f_81462_, (Object)context.getMachineTile()).m_78963_((float)context.getModifiedValue(this.luck, this, "luck")).m_78975_(Registration.CUSTOM_MACHINE_LOOT_PARAMETER_SET);
            this.toOutput = table.m_230922_(lootContext);
        }
        Iterator<ItemStack> iterator = this.toOutput.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (component.getSpaceForItem("", stack.m_41720_(), stack.m_41783_()) < stack.m_41613_()) {
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.item.error.output", (Object[])new Object[]{stack.m_41613_(), Component.m_237115_((String)stack.m_41778_())}));
            }
            component.addToOutputs("", stack.m_41720_(), stack.m_41613_(), stack.m_41783_());
            iterator.remove();
        }
        return CraftingResult.success();
    }

    @Override
    public MachineComponentType getComponentType() {
        return (MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get();
    }

    @Override
    public List<IJEIIngredientWrapper<ItemStack>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new LootTableIngredientWrapper(this.lootTable));
    }
}

