/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.IDelayedRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.render.CustomMachineRenderer;
import fr.frinn.custommachinery.common.component.StructureMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.CPlaceStructurePacket;
import fr.frinn.custommachinery.common.util.BlockStructure;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;

public class StructureRequirement
extends AbstractDelayedChanceableRequirement<StructureMachineComponent>
implements ITickableRequirement<StructureMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<StructureRequirement> CODEC = NamedCodec.record(structureRequirementInstance -> structureRequirementInstance.group(NamedCodec.STRING.listOf().listOf().fieldOf("pattern").forGetter(requirement -> requirement.pattern), NamedCodec.unboundedMap(DefaultCodecs.CHARACTER, IIngredient.BLOCK, "Map<Character, Block>").fieldOf("keys").forGetter(requirement -> requirement.keys), NamedCodec.enumCodec(Action.class).optionalFieldOf("action", Action.CHECK).forGetter(requirement -> requirement.action), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractDelayedChanceableRequirement::getChance), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("delay", 0.0).forGetter(IDelayedRequirement::getDelay)).apply((Applicative)structureRequirementInstance, (pattern, keys, action, chance, delay) -> {
        StructureRequirement requirement = new StructureRequirement((List<List<String>>)pattern, (Map<Character, IIngredient<PartialBlockState>>)keys, (Action)((Object)((Object)action)));
        requirement.setChance((double)chance);
        requirement.setDelay((double)delay);
        return requirement;
    }), "Structure requirement");
    private final List<List<String>> pattern;
    private final Map<Character, IIngredient<PartialBlockState>> keys;
    private final Action action;
    private final BlockStructure structure;

    public StructureRequirement(List<List<String>> pattern, Map<Character, IIngredient<PartialBlockState>> keys, Action action) {
        super(RequirementIOMode.INPUT);
        this.pattern = pattern;
        this.keys = keys;
        this.action = action;
        BlockStructure.Builder builder = BlockStructure.Builder.start();
        for (List<String> list : pattern) {
            builder.aisle(list.toArray(new String[0]));
        }
        for (Map.Entry entry : keys.entrySet()) {
            builder.where(((Character)entry.getKey()).charValue(), (IIngredient)entry.getValue());
        }
        this.structure = builder.build();
    }

    @Override
    public RequirementType<StructureRequirement> getType() {
        return (RequirementType)Registration.STRUCTURE_REQUIREMENT.get();
    }

    @Override
    public boolean test(StructureMachineComponent component, ICraftingContext context) {
        return switch (this.action) {
            case Action.CHECK, Action.DESTROY, Action.BREAK -> component.checkStructure(this.structure);
            default -> true;
        };
    }

    @Override
    public CraftingResult processStart(StructureMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0) {
            return CraftingResult.pass();
        }
        switch (this.action) {
            case BREAK: {
                component.destroyStructure(this.structure, true);
                break;
            }
            case DESTROY: {
                component.destroyStructure(this.structure, false);
                break;
            }
            case PLACE_BREAK: {
                component.placeStructure(this.structure, true);
                break;
            }
            case PLACE_DESTROY: {
                component.placeStructure(this.structure, false);
            }
        }
        return CraftingResult.success();
    }

    @Override
    public CraftingResult processEnd(StructureMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 1.0) {
            return CraftingResult.pass();
        }
        switch (this.action) {
            case BREAK: {
                component.destroyStructure(this.structure, true);
                break;
            }
            case DESTROY: {
                component.destroyStructure(this.structure, false);
                break;
            }
            case PLACE_BREAK: {
                component.placeStructure(this.structure, true);
                break;
            }
            case PLACE_DESTROY: {
                component.placeStructure(this.structure, false);
            }
        }
        return CraftingResult.success();
    }

    @Override
    public MachineComponentType<StructureMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.STRUCTURE_MACHINE_COMPONENT.get();
    }

    @Override
    public CraftingResult processTick(StructureMachineComponent component, ICraftingContext context) {
        if (this.action != Action.CHECK && this.getDelay() < context.getRemainingTime() / (double)context.getRecipe().getRecipeTime()) {
            return CraftingResult.pass();
        }
        if (component.checkStructure(this.structure)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.m_237115_((String)"custommachinery.requirements.structure.error"));
    }

    @Override
    public CraftingResult execute(StructureMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0 && this.getDelay() != 1.0 && this.action != Action.CHECK) {
            switch (this.action) {
                case BREAK: {
                    component.destroyStructure(this.structure, true);
                    break;
                }
                case DESTROY: {
                    component.destroyStructure(this.structure, false);
                    break;
                }
                case PLACE_BREAK: {
                    component.placeStructure(this.structure, true);
                    break;
                }
                case PLACE_DESTROY: {
                    component.placeStructure(this.structure, false);
                }
            }
            return CraftingResult.success();
        }
        return CraftingResult.pass();
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        info.addTooltip((Component)Component.m_237115_((String)"custommachinery.requirements.structure.info"));
        info.addTooltip((Component)Component.m_237115_((String)"custommachinery.requirements.structure.click"));
        this.pattern.stream().flatMap(Collection::stream).flatMap(s -> s.chars().mapToObj(c -> Character.valueOf((char)c))).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((key, amount) -> {
            IIngredient<PartialBlockState> ingredient = this.keys.get(key);
            if (ingredient != null && amount > 0L) {
                info.addTooltip((Component)Component.m_237110_((String)"custommachinery.requirements.structure.list", (Object[])new Object[]{amount, Utils.getBlockName(ingredient).m_130940_(ChatFormatting.GOLD)}));
            }
        });
        switch (this.action) {
            case BREAK: {
                info.addTooltip((Component)Component.m_237115_((String)"custommachinery.requirements.structure.break").m_130940_(ChatFormatting.DARK_RED));
                break;
            }
            case DESTROY: {
                info.addTooltip((Component)Component.m_237115_((String)"custommachinery.requirements.structure.destroy").m_130940_(ChatFormatting.DARK_RED));
                break;
            }
            case PLACE_BREAK: 
            case PLACE_DESTROY: {
                info.addTooltip((Component)Component.m_237115_((String)"custommachinery.requirements.structure.place").m_130940_(ChatFormatting.DARK_RED));
            }
        }
        info.addTooltip((Component)Component.m_237115_((String)"custommachinery.requirements.structure.creative").m_130940_(ChatFormatting.DARK_PURPLE), IDisplayInfo.TooltipPredicate.CREATIVE);
        info.setClickAction((machine, recipe, mouseButton) -> {
            if (ClientHandler.isShiftKeyDown()) {
                new CPlaceStructurePacket(machine.getId(), this.pattern, this.keys).sendToServer();
            } else {
                CustomMachineRenderer.addRenderBlock(machine.getId(), this.structure::getBlocks);
            }
        });
        info.setItemIcon(Items.f_42352_);
    }

    public static enum Action {
        CHECK,
        DESTROY,
        BREAK,
        PLACE_BREAK,
        PLACE_DESTROY;

    }
}

