/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.integration.kubejs.KubeJSIntegration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    public static boolean writeMachineJSON(MinecraftServer server, CustomMachine machine) {
        if (server != null) {
            DataResult result = CustomMachine.CODEC.encodeStart(JsonOps.INSTANCE, machine);
            JsonElement json = (JsonElement)result.resultOrPartial(arg_0 -> ((Logger)CustomMachinery.LOGGER).error(arg_0)).orElseThrow(() -> new JsonParseException("Error while writing custom machine: " + machine.getLocation().getId() + " to JSON"));
            try {
                List<Path> paths = FileUtils.getCustomMachineJson(server, machine.getLocation().getId());
                for (Path path : paths) {
                    File file = new File(path.toUri());
                    file.getParentFile().mkdirs();
                    CustomMachinery.LOGGER.info("Writing machine: " + machine.getLocation().getId() + " to: " + file.getPath());
                    if (!file.exists() && !file.createNewFile()) continue;
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    JsonWriter writer = gson.newJsonWriter((Writer)new FileWriter(file));
                    gson.toJson(json, writer);
                    writer.close();
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean deleteMachineJSON(MinecraftServer server, ResourceLocation location) {
        if (server == null) {
            return false;
        }
        ResourceLocation trueLocation = new ResourceLocation(location.m_135827_(), "machines/" + location.m_135815_() + ".json");
        for (PackResources pack : server.m_177941_().m_7536_().toList()) {
            File file;
            Path path;
            if (!pack.m_7211_(PackType.SERVER_DATA, trueLocation)) continue;
            if (pack instanceof FilePackResources) {
                FilePackResources filePackResources = (FilePackResources)pack;
                filePackResources.close();
                Path zipPath = Platform.getGameFolder().resolve(filePackResources.f_10203_.toString().substring(2));
                try (FileSystem zipfs = FileSystems.newFileSystem(zipPath, Map.of("create", "false"));){
                    Path path2 = zipfs.getPath("data/" + trueLocation.m_135827_() + "/" + trueLocation.m_135815_(), new String[0]);
                    if (Files.exists(path2, new LinkOption[0])) {
                        Files.delete(path2);
                        CustomMachinery.LOGGER.info("Deleted custom machine json for id {} in zip archive {}", (Object)location, (Object)zipPath);
                    }
                }
                catch (IOException e) {
                    CustomMachinery.LOGGER.error(e.getMessage(), (Throwable)e);
                }
                try {
                    filePackResources.m_10247_();
                }
                catch (IOException e) {}
                continue;
            }
            if (pack instanceof AbstractPackResources) {
                AbstractPackResources packResources = (AbstractPackResources)pack;
                path = Platform.getGameFolder().resolve(packResources.f_10203_.toString().substring(2)).resolve("data/" + trueLocation.m_135827_() + "/" + trueLocation.m_135815_());
                file = new File(path.toUri());
                if (!file.exists() || !file.isFile() || !file.delete()) continue;
                CustomMachinery.LOGGER.info("Deleted custom machine json for id {} at path {}", (Object)location, (Object)path);
                continue;
            }
            if (!pack.m_8017_().contains("KubeJS") || !(file = new File((path = KubeJSIntegration.getMachineJsonPath(trueLocation)).toUri())).exists() || !file.isFile() || !file.delete()) continue;
            CustomMachinery.LOGGER.info("Deleted custom machine json for id {} at path {}", (Object)location, (Object)path);
        }
        return false;
    }

    public static List<Path> getCustomMachineJson(MinecraftServer server, ResourceLocation location) {
        ResourceLocation trueLocation = new ResourceLocation(location.m_135827_(), "machines/" + location.m_135815_() + ".json");
        ArrayList<Path> paths = new ArrayList<Path>();
        for (PackResources pack : server.m_177941_().m_7536_().toList()) {
            if (!pack.m_7211_(PackType.SERVER_DATA, trueLocation) || !pack.m_8017_().contains("KubeJS")) continue;
            paths.add(KubeJSIntegration.getMachineJsonPath(trueLocation));
        }
        return paths;
    }
}

