/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.ingredient;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.util.TagUtil;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class FluidTagIngredient
implements IIngredient<Fluid> {
    private static final NamedCodec<FluidTagIngredient> CODEC_FOR_DATAPACK = NamedCodec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)FluidTagIngredient.create(string));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error((String)e.getMessage());
        }
    }, FluidTagIngredient::toString, "Fluid tag ingredient");
    private static final NamedCodec<FluidTagIngredient> CODEC_FOR_KUBEJS = DefaultCodecs.tagKey(Registry.f_122899_).fieldOf("tag").xmap(FluidTagIngredient::new, ingredient -> ingredient.tag, "Fluid tag ingredient");
    public static final NamedCodec<FluidTagIngredient> CODEC = NamedCodec.either(CODEC_FOR_DATAPACK, CODEC_FOR_KUBEJS, "Fluid Tag Ingredient").xmap(either -> (FluidTagIngredient)either.map(Function.identity(), Function.identity()), Either::left, "Fluid tag ingredient");
    private final TagKey<Fluid> tag;

    private FluidTagIngredient(TagKey<Fluid> tag) {
        this.tag = tag;
    }

    public static FluidTagIngredient create(String s) throws IllegalArgumentException {
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        if (!Utils.isResourceNameValid(s)) {
            throw new IllegalArgumentException(String.format("Invalid tag id : %s", s));
        }
        TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)new ResourceLocation(s));
        return new FluidTagIngredient((TagKey<Fluid>)tag);
    }

    public static FluidTagIngredient create(TagKey<Fluid> tag) throws IllegalArgumentException {
        return new FluidTagIngredient(tag);
    }

    @Override
    public List<Fluid> getAll() {
        return TagUtil.getFluids(this.tag).toList();
    }

    @Override
    public boolean test(Fluid fluid) {
        return this.getAll().contains(fluid);
    }

    public String toString() {
        return "#" + this.tag.f_203868_();
    }
}

