/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.client;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import fr.frinn.custommachinery.api.machine.IMachineAppearance;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.forge.client.CustomMachineOverrideList;
import fr.frinn.custommachinery.impl.util.IMachineModelLocation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomMachineBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<MachineAppearance> APPEARANCE = new ModelProperty();
    public static final ModelProperty<MachineStatus> STATUS = new ModelProperty();
    private final CustomMachineOverrideList overrideList = new CustomMachineOverrideList();
    private final Map<MachineStatus, ResourceLocation> defaults;

    public CustomMachineBakedModel(Map<MachineStatus, ResourceLocation> defaults) {
        this.defaults = defaults;
    }

    public boolean m_7541_() {
        return (Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get();
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return true;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.getMachineModel(data).getRenderTypes(state, rand, data);
    }

    public List<RenderType> getRenderTypes(ItemStack stack, boolean fabulous) {
        return CustomMachineItem.getMachine(stack).map(machine -> this.getMachineItemModel(machine.getAppearance(MachineStatus.IDLE)).getRenderTypes(stack, fabulous)).orElse(List.of(RenderTypeHelper.getFallbackItemRenderType((ItemStack)stack, (BakedModel)this, (boolean)fabulous)));
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, RenderType type) {
        BakedModel model = this.getMachineModel(data);
        if (state != null && state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return this.getRotatedQuads(model, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), side, rand, type);
        }
        return model.getQuads(state, side, rand, ModelData.EMPTY, type);
    }

    private List<BakedQuad> getRotatedQuads(BakedModel model, Direction machineFacing, Direction side, RandomSource random, RenderType type) {
        Direction originalSide = this.getRotatedDirection(machineFacing, side);
        List finalQuads = model.getQuads(null, originalSide, random, ModelData.EMPTY, type);
        return finalQuads.stream().map(quad -> this.rotateQuad((BakedQuad)quad, this.getRotation(machineFacing), side == null ? quad.m_111306_() : side)).toList();
    }

    private Quaternion getRotation(Direction machineFacing) {
        return switch (machineFacing) {
            case Direction.EAST -> Vector3f.f_122224_.m_122240_(90.0f);
            case Direction.SOUTH -> Vector3f.f_122224_.m_122240_(180.0f);
            case Direction.WEST -> Vector3f.f_122224_.m_122240_(270.0f);
            default -> Quaternion.f_80118_;
        };
    }

    private BakedQuad rotateQuad(BakedQuad quad, Quaternion rotation, Direction side) {
        int[] quadData = quad.m_111303_();
        int[] newQuadData = Arrays.copyOf(quadData, quadData.length);
        for (int i = 0; i < quadData.length / 8; ++i) {
            float x = Float.intBitsToFloat(quadData[i * 8]);
            float y = Float.intBitsToFloat(quadData[i * 8 + 1]);
            float z = Float.intBitsToFloat(quadData[i * 8 + 2]);
            Vector4f pos = new Vector4f(x - 0.5f, y - 0.5f, z - 0.5f, 1.0f);
            pos.m_123609_(rotation);
            pos.m_123621_();
            newQuadData[i * 8] = Float.floatToRawIntBits(pos.m_123601_() + 0.5f);
            newQuadData[i * 8 + 1] = Float.floatToRawIntBits(pos.m_123615_() + 0.5f);
            newQuadData[i * 8 + 2] = Float.floatToRawIntBits(pos.m_123616_() + 0.5f);
            newQuadData[i * 8 + 7] = 0;
        }
        return new BakedQuad(newQuadData, quad.m_111305_(), side, quad.m_173410_(), quad.m_111307_());
    }

    public Direction getRotatedDirection(Direction machineFacing, @Nullable Direction quad) {
        if (quad == null || quad.m_122434_() == Direction.Axis.Y) {
            return quad;
        }
        return switch (machineFacing) {
            case Direction.WEST -> Direction.m_122407_((int)((quad.m_122416_() + 1) % 4));
            case Direction.SOUTH -> Direction.m_122407_((int)((quad.m_122416_() + 2) % 4));
            case Direction.EAST -> Direction.m_122407_((int)((quad.m_122416_() + 3) % 4));
            default -> quad;
        };
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.getMachineModel(data).getParticleIcon(data);
    }

    private BakedModel getMachineModel(@NotNull ModelData data) {
        MachineAppearance appearance = (MachineAppearance)data.get(APPEARANCE);
        MachineStatus status = (MachineStatus)((Object)data.get(STATUS));
        BakedModel model = appearance != null ? this.getMachineBlockModel(appearance, (MachineStatus)((Object)data.get(STATUS))) : (data.get(STATUS) != null ? Minecraft.m_91087_().m_91304_().getModel(this.defaults.get((Object)status)) : Minecraft.m_91087_().m_91304_().getModel(this.defaults.get((Object)MachineStatus.IDLE)));
        return model;
    }

    public BakedModel getMachineBlockModel(IMachineAppearance appearance, @Nullable MachineStatus status) {
        BakedModel missing;
        BakedModel model = missing = Minecraft.m_91087_().m_91304_().m_119409_();
        IMachineModelLocation blockModelLocation = appearance.getBlockModel();
        if (blockModelLocation.getState() != null) {
            model = Minecraft.m_91087_().m_91289_().m_110910_(blockModelLocation.getState());
        } else if (blockModelLocation.getLoc() != null && blockModelLocation.getProperties() != null) {
            model = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(blockModelLocation.getLoc(), blockModelLocation.getProperties()));
        } else if (blockModelLocation.getLoc() != null) {
            model = Minecraft.m_91087_().m_91304_().getModel(blockModelLocation.getLoc());
        }
        if (model == missing) {
            model = Minecraft.m_91087_().m_91304_().getModel(this.defaults.get((Object)(status == null ? MachineStatus.IDLE : status)));
        }
        return model;
    }

    public BakedModel getMachineItemModel(@Nullable IMachineAppearance appearance) {
        BakedModel missing;
        BakedModel model = missing = Minecraft.m_91087_().m_91304_().m_119409_();
        if (appearance != null) {
            IMachineModelLocation itemModelLocation = appearance.getItemModel();
            if (itemModelLocation.getState() != null && itemModelLocation.getState().m_60734_().m_5456_() != Items.f_41852_) {
                model = Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(itemModelLocation.getState().m_60734_().m_5456_());
            } else if (itemModelLocation.getLoc() != null) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemModelLocation.getLoc());
                model = itemModelLocation.getProperties() != null ? Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(itemModelLocation.getLoc(), itemModelLocation.getProperties())) : (item != null && item != Items.f_41852_ && Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(item) != null ? Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(item) : Minecraft.m_91087_().m_91304_().getModel(itemModelLocation.getLoc()));
            }
            if (model == missing) {
                model = this.getMachineBlockModel(appearance, MachineStatus.IDLE);
            }
        }
        if (model == missing) {
            model = Minecraft.m_91087_().m_91304_().getModel(this.defaults.get((Object)MachineStatus.IDLE));
        }
        return model;
    }
}

