/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.integration.jade;

import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;

public class CustomMachineComponentProvider
implements IBlockComponentProvider {
    public static final CustomMachineComponentProvider INSTANCE = new CustomMachineComponentProvider();
    public static final ResourceLocation ID = new ResourceLocation("custommachinery", "machine_component_provider");

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlockEntity() instanceof CustomMachineTile) {
            Component ownerName;
            CompoundTag nbt = accessor.getServerData().m_128469_("custommachinery");
            if (nbt.m_128456_()) {
                return;
            }
            boolean errored = false;
            if (nbt.m_128425_("owner", 8) && (ownerName = TextComponentUtils.fromJsonString(nbt.m_128461_("owner"))) != null && !ownerName.getString().isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)"custommachinery.machine.info.owner", (Object[])new Object[]{ownerName}));
            }
            if (nbt.m_128425_("status", 1)) {
                MachineStatus machineStatus = MachineStatus.values()[nbt.m_128445_("status")];
                MutableComponent status = machineStatus.getTranslatedName();
                switch (machineStatus) {
                    case ERRORED: {
                        status.m_130940_(ChatFormatting.RED);
                        break;
                    }
                    case RUNNING: {
                        status.m_130940_(ChatFormatting.GREEN);
                        break;
                    }
                    case PAUSED: {
                        status.m_130940_(ChatFormatting.GOLD);
                    }
                }
                tooltip.add((Component)status);
                if (machineStatus == MachineStatus.ERRORED) {
                    errored = true;
                }
            }
            if (nbt.m_128425_("recipeProgressTime", 6) && nbt.m_128425_("recipeTotalTime", 6)) {
                double recipeProgressTime = nbt.m_128459_("recipeProgressTime");
                double recipeTotalTime = nbt.m_128459_("recipeTotalTime");
                float progress = (float)(recipeProgressTime / recipeTotalTime);
                MutableComponent component = Component.m_237113_((String)((int)recipeProgressTime + " / " + (int)recipeTotalTime));
                tooltip.add(tooltip.getElementHelper().progress(progress, (Component)component, tooltip.getElementHelper().progressStyle(), (IBoxStyle)BoxStyle.DEFAULT, true));
            }
            if (errored && nbt.m_128425_("errorMessage", 8)) {
                tooltip.add((Component)Component.Serializer.m_130701_((String)nbt.m_128461_("errorMessage")));
            }
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

