/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.integration.jade;

import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.IServerDataProvider;

public class CustomMachineServerDataProvider
implements IServerDataProvider<BlockEntity> {
    public static final CustomMachineServerDataProvider INSTANCE = new CustomMachineServerDataProvider();
    public static final ResourceLocation ID = new ResourceLocation("custommachinery", "machine_server_data_provider");

    public void appendServerData(CompoundTag nbt, ServerPlayer player, Level level, BlockEntity tile, boolean b) {
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile machine = (CustomMachineTile)tile;
            IProcessor processor = machine.getProcessor();
            CompoundTag tag = new CompoundTag();
            if (machine.getOwnerName() != null) {
                tag.m_128359_("owner", TextComponentUtils.toJsonString(machine.getOwnerName()));
            }
            tag.m_128344_("status", (byte)machine.getStatus().ordinal());
            if (processor instanceof MachineProcessor) {
                MachineProcessor machineProcessor = (MachineProcessor)processor;
                if (processor.getCurrentContext() != null) {
                    tag.m_128347_("recipeProgressTime", machineProcessor.getRecipeProgressTime());
                    tag.m_128347_("recipeTotalTime", (double)machineProcessor.getRecipeTotalTime());
                    tag.m_128359_("errorMessage", Component.Serializer.m_130703_((Component)machine.getMessage()));
                }
            }
            nbt.m_128365_("custommachinery", (Tag)tag);
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

