/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.transfer;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidTank
implements IFluidHandler {
    private final FluidMachineComponent component;

    public FluidTank(FluidMachineComponent component) {
        this.component = component;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public net.minecraftforge.fluids.FluidStack getFluidInTank(int i) {
        return FluidStackHooksForge.toForge((FluidStack)this.component.getFluidStack());
    }

    public int getTankCapacity(int i) {
        return (int)this.component.getCapacity();
    }

    public boolean isFluidValid(int i, @NotNull net.minecraftforge.fluids.FluidStack stack) {
        return this.component.isFluidValid(FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)stack));
    }

    public int fill(net.minecraftforge.fluids.FluidStack stack, IFluidHandler.FluidAction action) {
        if (!this.component.isFluidValid(FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)stack))) {
            return 0;
        }
        return (int)this.component.insert(stack.getFluid(), stack.getAmount(), stack.getTag(), action.simulate());
    }

    @NotNull
    public net.minecraftforge.fluids.FluidStack drain(net.minecraftforge.fluids.FluidStack stack, IFluidHandler.FluidAction action) {
        if (stack.isFluidEqual(FluidStackHooksForge.toForge((FluidStack)this.component.getFluidStack()))) {
            return FluidStackHooksForge.toForge((FluidStack)this.component.extract(stack.getAmount(), action.simulate()));
        }
        return net.minecraftforge.fluids.FluidStack.EMPTY;
    }

    @NotNull
    public net.minecraftforge.fluids.FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        return FluidStackHooksForge.toForge((FluidStack)this.component.extract(amount, action.simulate()));
    }
}

