/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.transfer;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.transfer.IFluidHelper;
import fr.frinn.custommachinery.forge.transfer.FluidTank;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeFluidHelper
implements IFluidHelper {
    @Override
    public boolean isFluidHandler(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    @Override
    public void fillTanksFromStack(List<FluidMachineComponent> tanks, ItemMachineComponent slot) {
        ItemStack stack = slot.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        IFluidHandlerItem handlerItem = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(() -> new IllegalStateException("Can't fill tanks from non fluid handler item: " + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
        for (FluidMachineComponent component : tanks) {
            net.minecraftforge.fluids.FluidStack extracted;
            long maxInsert;
            net.minecraftforge.fluids.FluidStack maxExtract = component.getFluidStack().isEmpty() ? handlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) : handlerItem.drain(new net.minecraftforge.fluids.FluidStack(component.getFluidStack().getFluid(), Integer.MAX_VALUE, component.getFluidStack().getTag()), IFluidHandler.FluidAction.SIMULATE);
            if (maxExtract.isEmpty() || (maxInsert = component.insert(maxExtract.getFluid(), maxExtract.getAmount(), maxExtract.getTag(), true)) <= 0L || (extracted = handlerItem.drain(new net.minecraftforge.fluids.FluidStack(maxExtract.getFluid(), Utils.toInt(maxInsert), maxExtract.getTag()), IFluidHandler.FluidAction.EXECUTE)).getAmount() <= 0) continue;
            component.insert(extracted.getFluid(), extracted.getAmount(), extracted.getTag(), false);
        }
        slot.setItemStack(handlerItem.getContainer());
    }

    @Override
    public void fillStackFromTanks(ItemMachineComponent slot, List<FluidMachineComponent> tanks) {
        ItemStack stack = slot.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        IFluidHandlerItem handlerItem = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(() -> new IllegalStateException("Can't fill tanks from non fluid handler item: " + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
        for (FluidMachineComponent component : tanks) {
            for (int i = 0; i < handlerItem.getTanks(); ++i) {
                net.minecraftforge.fluids.FluidStack extracted;
                int maxInsert;
                net.minecraftforge.fluids.FluidStack maxExtract;
                if (!handlerItem.getFluidInTank(i).isEmpty() && !handlerItem.getFluidInTank(i).isFluidEqual(FluidStackHooksForge.toForge((FluidStack)component.getFluidStack())) || (maxExtract = FluidStackHooksForge.toForge((FluidStack)component.extract(Integer.MAX_VALUE, true))).isEmpty() || (maxInsert = handlerItem.fill(maxExtract, IFluidHandler.FluidAction.SIMULATE)) <= 0 || (extracted = FluidStackHooksForge.toForge((FluidStack)component.extract(maxInsert, false))).getAmount() <= 0) continue;
                handlerItem.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        slot.setItemStack(handlerItem.getContainer());
    }

    @Override
    public ItemStack transferFluid(ItemStack stack, FluidMachineComponent component) {
        FluidTank tank = new FluidTank(component);
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, null, (boolean)true);
        if (result.isSuccess()) {
            return result.getResult();
        }
        result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, null, (boolean)true);
        if (result.isSuccess()) {
            return result.getResult();
        }
        return stack;
    }
}

