/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.transfer;

import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSlot
implements IItemHandler {
    private final ItemMachineComponent component;
    @Nullable
    private final Direction side;

    public ItemSlot(ItemMachineComponent component, @Nullable Direction side) {
        this.component = component;
        this.side = side;
    }

    public ItemMachineComponent getComponent() {
        return this.component;
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int index) {
        return this.component.getItemStack();
    }

    @NotNull
    public ItemStack insertItem(int index, @NotNull ItemStack stack, boolean simulate) {
        if (this.side != null && !this.component.getConfig().getSideMode(this.side).isInput()) {
            return stack;
        }
        if (!this.component.isItemValid(stack)) {
            return stack;
        }
        int inserted = this.component.insert(stack.m_41720_(), stack.m_41613_(), stack.m_41783_(), simulate);
        if (inserted == 0) {
            return stack;
        }
        if (inserted == stack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        return Utils.makeItemStack(stack.m_41720_(), stack.m_41613_() - inserted, stack.m_41783_());
    }

    @NotNull
    public ItemStack extractItem(int index, int amount, boolean simulate) {
        if (this.side != null && !this.component.getConfig().getSideMode(this.side).isOutput()) {
            return ItemStack.f_41583_;
        }
        return this.component.extract(amount, simulate);
    }

    public int getSlotLimit(int index) {
        return this.component.getCapacity();
    }

    public boolean isItemValid(int index, @NotNull ItemStack stack) {
        return this.component.isItemValid(stack);
    }
}

