/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.transfer;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidedFluidStorage
implements IFluidHandler {
    @Nullable
    private final Direction direction;
    private final FluidComponentHandler handler;

    public SidedFluidStorage(@Nullable Direction direction, FluidComponentHandler handler) {
        this.direction = direction;
        this.handler = handler;
    }

    public List<FluidMachineComponent> getSideComponents(Predicate<SideMode> filter) {
        if (this.direction == null) {
            return this.handler.getComponents();
        }
        return this.handler.getComponents().stream().filter(component -> filter.test(component.getConfig().getSideMode(this.direction))).toList();
    }

    public int getTanks() {
        return this.handler.getComponents().size();
    }

    @NotNull
    public net.minecraftforge.fluids.FluidStack getFluidInTank(int tank) {
        return FluidStackHooksForge.toForge((FluidStack)((FluidMachineComponent)this.handler.getComponents().get(tank)).getFluidStack());
    }

    public int getTankCapacity(int tank) {
        return Utils.toInt(((FluidMachineComponent)this.handler.getComponents().get(tank)).getCapacity());
    }

    public boolean isFluidValid(int tank, @NotNull net.minecraftforge.fluids.FluidStack stack) {
        return ((FluidMachineComponent)this.handler.getComponents().get(tank)).isFluidValid(FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)stack));
    }

    public int fill(net.minecraftforge.fluids.FluidStack forgeStack, IFluidHandler.FluidAction action) {
        AtomicLong remaining = new AtomicLong(forgeStack.getAmount());
        FluidStack stack = FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)forgeStack);
        this.getSideComponents(SideMode::isInput).stream().filter(component -> component.isFluidValid(stack) && component.getRemainingSpace() > 0L && component.getMode().isInput()).sorted(Comparator.comparingInt(component -> component.getFluidStack().isFluidEqual(stack) ? -1 : 1)).forEach(component -> {
            long toInput = Math.min(remaining.get(), component.insert(stack.getFluid(), stack.getAmount(), stack.getTag(), true));
            if (toInput > 0L) {
                remaining.addAndGet(-toInput);
                if (action.execute()) {
                    component.insert(stack.getFluid(), toInput, stack.getTag(), false);
                }
            }
        });
        return (int)(stack.getAmount() - remaining.get());
    }

    @NotNull
    public net.minecraftforge.fluids.FluidStack drain(net.minecraftforge.fluids.FluidStack maxDrain, IFluidHandler.FluidAction action) {
        int remainingToDrain = maxDrain.getAmount();
        for (FluidMachineComponent component : this.getSideComponents(SideMode::isOutput)) {
            if (component.getFluidStack().isEmpty() || !component.getFluidStack().isFluidEqual(FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)maxDrain))) continue;
            net.minecraftforge.fluids.FluidStack stack = FluidStackHooksForge.toForge((FluidStack)component.extract(maxDrain.getAmount(), true));
            if (stack.getAmount() >= remainingToDrain) {
                if (action.execute()) {
                    component.extract(remainingToDrain, false);
                }
                return maxDrain;
            }
            if (action.execute()) {
                component.extract(stack.getAmount(), false);
            }
            remainingToDrain -= stack.getAmount();
        }
        if (remainingToDrain == maxDrain.getAmount()) {
            return net.minecraftforge.fluids.FluidStack.EMPTY;
        }
        return new net.minecraftforge.fluids.FluidStack(maxDrain.getFluid(), maxDrain.getAmount() - remainingToDrain, maxDrain.getTag());
    }

    @NotNull
    public net.minecraftforge.fluids.FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        net.minecraftforge.fluids.FluidStack toDrain = net.minecraftforge.fluids.FluidStack.EMPTY;
        int remainingToDrain = maxDrain;
        for (FluidMachineComponent component : this.getSideComponents(SideMode::isOutput)) {
            if (component.getFluidStack().isEmpty() || !toDrain.isEmpty() && !component.getFluidStack().isFluidEqual(FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)toDrain))) continue;
            net.minecraftforge.fluids.FluidStack stack = FluidStackHooksForge.toForge((FluidStack)component.extract(remainingToDrain, true));
            if (stack.getAmount() >= remainingToDrain) {
                if (action.execute()) {
                    component.extract(remainingToDrain, false);
                }
                return new net.minecraftforge.fluids.FluidStack(stack.getFluid(), maxDrain, stack.getTag());
            }
            if (toDrain.isEmpty()) {
                toDrain = stack;
            }
            if (action.execute()) {
                component.extract(stack.getAmount(), false);
            }
            remainingToDrain -= stack.getAmount();
        }
        if (toDrain.isEmpty() || remainingToDrain == maxDrain) {
            return net.minecraftforge.fluids.FluidStack.EMPTY;
        }
        return new net.minecraftforge.fluids.FluidStack(toDrain.getFluid(), maxDrain - remainingToDrain, toDrain.getTag());
    }
}

